<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;


class Suspend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        foreach ($selected as $id) {
            if ($site = $siteRepository->findUnsuspend($id)) {
                \Visiosoft\SiteModule\Site\Jobs\SuspendSite::dispatch($site);
            }
        }

        if ($selected) {
            $this->messages->success(trans('module::message.send_suspend_request',['count' => count($selected)]));
        }

    }
}