<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BackupStatusChange;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\CreatingSite;
use Visiosoft\SiteModule\Site\Event\ErrorCreateSite;

class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder, MessageBag $message, SiteRepositoryInterface $siteRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        //Get Entry Before Saving
        $entry_before_saving = $siteRepository->find($builder->getFormEntryId());

        $builder->saveForm();

        //Get Entry After Saving
        $entry = $builder->getFormEntry();

        if ($builder->getFormMode() === 'create') {
            $site = $builder->getFormEntry();

            $response = array_first(event(new BuildSite($site)));

            if (!$response['status']) {
                $site->updateErrorMsg($response['message']);
                $message->error($response['message']);

                event(new ErrorCreateSite($site));
            } else {
                $site->changeStatus('pending');

                event(new CreatingSite($site));
            }
        }

        //Check Change Backup Status
        if ($entry_before_saving->backup_status != $entry->backup_status) {
            event(new BackupStatusChange($entry));
        }
    }
}
