<?php namespace Visiosoft\SiteModule\Site\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class SiteTableButtons
{
    public function handle(SiteTableBuilder $builder)
    {
        $builder->setButtons(
            [
                'status' => [
                    'attributes' => [
                        'data-toggle' => 'tooltip',
                        'data-placement' => 'top',
                        'title' => function (EntryInterface $entry) {
                            return ($entry->status == "error") ? $entry->message : '';
                        },
                    ],
                    'text' => function (EntryInterface $entry) {
                        if ($entry->status == "incomplete") {
                            return "visiosoft.module.site::button.install_site";
                        } elseif ($entry->status == "completed") {
                            return "visiosoft.module.site::button.active";
                        } elseif ($entry->status == "pending") {
                            return "visiosoft.module.site::button.pending";
                        } else {
                            return "visiosoft.module.site::button.error";
                        }
                    },
                    'href' => function (EntryInterface $entry) {
                        if ($entry->status == "incomplete") {
                            return route('visiosoft.module.site::admin.complete.on.manuel', ['id' => $entry->getId()]);
                        }
                    },
                    'type' => function (EntryInterface $entry) {
                        if ($entry->status == "completed") {
                            return "success";
                        } elseif ($entry->status == "pending") {
                            return "default";
                        } else {
                            return "warning";
                        }
                    },
                    'icon' => function (EntryInterface $entry) {
                        if ($entry->status == "incomplete") {
                            return "fa fa-credit-card-alt";
                        } elseif ($entry->status == "completed") {
                            return "fa fa-check";
                        } elseif ($entry->status == "pending") {
                            return "fa fa-clock-o";
                        } else {
                            return "fa fa-times";
                        }
                    },
                ],
                'settings' => [
                    'text'     => false,
                    'href'     => false,
                    'dropdown' => [
                        'edit' => [
                            'icon' => false,
                        ],
                        'show-addons' => [
                            'href' => route('visiosoft.module.site::admin.addon.list') . '?filter_subdomain={entry.id}'
                        ],
                        'add-addon' => [
                            'href' => route('visiosoft.module.site::admin.add.addon') . '?site={entry.id}',
                        ],
                        'add_domain' => [
                            'href' => route('visiosoft.module.site::admin.domain.create') . '?site={entry.id}',
                        ],
                        'add_bundle' => [
                            'href' => route('visiosoft.module.site::admin.add.bundle') . '?site={entry.id}',
                        ],
                    ],
                ],
            ]
        );
    }
}
