<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;


class unSuspend extends ActionHandler
{
    public function handle(SiteTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        foreach ($selected as $id) {

            $site = $model->newQuery()->find($id);
            if (!is_null($site)) {
                $site->update
                ([
                    'suspend_at' => null,
                ]);
                event(new SuspendSite($site, "false"));
            }
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.unSuspended', ['count' => count($selected)]));
        }
    }
}