<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Event\UpdateSite;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;


class Update extends ActionHandler
{
    public function handle(SiteTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        foreach ($selected as $id) {

            $site = $model->newQuery()->find($id);
            if (!is_null($site)) {
                $site->update
                ([
                    'update_at' => date('Y-m-d H:i:s'),
                ]);
                event(new UpdateSite($site));
            }
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.updated',['count' => count($selected)]));
        }
    }
}