<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Subscription\Event\SiteCreateWithPaddle;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class newSiteWithPaddle
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SiteCreateWithPaddle $event)
    {
        $paddleParameters = $event->getSubscription();
        $password = str_random(8);
        $user = $this->user->findByEmail($paddleParameters['email']);
        if (!is_null($user)) {
            $site = $this->site->createSite($paddleParameters['subdomain'], $password, $user);

            return ['status' => true, 'relation' => $site];
        }
    }
}
