<?php namespace Visiosoft\SiteModule\Site\AddAddonForm;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\SiteModule\Site\SiteModel;

/**
 * Class PostFormFields
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class AddAddonFormFields
{

    /**
     * @param AddAddonFormBuilder $builder
     */
    public function handle(AddAddonFormBuilder $builder)
    {
        $builder->setFields(
            [
                'subdomain' => [
                    'type' => 'anomaly.field_type.relationship',
                    'config' => [
                        'related' => SiteModel::class,
                        'default_value' => request('site'),
                    ],
                ],
                'addon' => [
                    'type' => 'anomaly.field_type.relationship',
                    'config' => [
                        'related' => AdvModel::class,
                    ],
                ]
            ]
        );
    }
}
