<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSiteCreateAddonStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'addon',
        'title_column' => 'addon',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subdomain' => [
            'required' => true,
        ],
        'addon' => [
            'required' => true,
        ],
    ];

}
