<?php namespace Visiosoft\SiteModule\Site\Event;

use Visiosoft\SiteModule\Site\SiteModel;

class BuildSite
{

    /**
     * @var
     */
    private $site;

    /**
     * BuildSite constructor.
     * @param $site
     */
    public function __construct($site)
    {
        $this->site = $site;
    }

    /**
     * @return SiteModel
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getSubdomain()
    {
        return $this->getSite()->subdomain_name;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getUser()
    {
        return $this->getSite()->assign;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getPassword()
    {
        return $this->getSite()->password;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getType()
    {
        return $this->getSite()->type;
    }

    public function getToken()
    {
        return $this->getSite()->getToken();
    }

}
