<?php namespace Visiosoft\SiteModule\Bundle\Listener;

use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Traits\PaymentBundle;

class OrderApproved
{
    use PaymentBundle;
    private $site;
    protected $bundleRepository;

    public function __construct(SiteRepositoryInterface $site,
                                BundleRepositoryInterface $bundleRepository)
    {
        $this->site = $site;
        $this->bundleRepository = $bundleRepository;
    }

    public function handle(\Visiosoft\OrdersModule\Order\Events\OrderApproved $event)
    {
        foreach ($event->getOrderDetail() as $order) {
            if ($order->item_type == "bundle"
                and $bundle = $this->bundleRepository->find($order->item_id)
                and $site = $this->site->find($order->related_id)) {

                $this->installBundleAddons($bundle, $site);
            }
        }
    }
}
