<?php namespace Visiosoft\SiteModule\Site\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;
use Anomaly\UsersModule\User\UserModel;

interface SiteRepositoryInterface extends EntryRepositoryInterface
{
    /**
     * @param $subdomain
     * @return mixed
     */
    public function findBySubdomain($subdomain);

    /**
     * @param $subdomain
     * @param $password
     * @param UserModel $user
     * @return mixed
     */
    public function createSite($subdomain, $password, UserModel $user,$subscription);

    /**
     * @param $id
     * @return mixed
     */
    public function suspend($id);

    /**
     * @param $id
     * @return mixed
     */
    public function unsuspend($id);

    /**
     * @param $user_id
     * @return mixed
     */
    public function findByAssing($user_id, $type = null);

    /**
     * @param $id
     * @return mixed
     */
    public function deleteSite($id);

    /**
     * @param $domain
     * @return mixed
     */
    public function editDomain($domain);
}
