<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSiteCreateAutoRefresh extends Migration
{
    protected $stream = [
        'slug' => 'site',
    ];

    protected $fields = [
        'auto_refresh' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'reinstall_addons' => [
            'type' => 'anomaly.field_type.multiple',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class,
            ],
        ],
    ];

    protected $assignments = [
        'auto_refresh',
        'reinstall_addons',
    ];

}
