<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;


class Suspend extends ActionHandler
{
    public function handle(SiteTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        foreach ($selected as $id) {

            $site = $model->newQuery()->find($id);
            if (!is_null($site)) {
                $site->update
                ([
                    'suspend_at' => date('Y-m-d H:i:s'),
                ]);
                event(new SuspendSite($site, "true"));
            }
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.suspended', ['count' => count($selected)]));
        }
    }
}