<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\User;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\ActivatedSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\SiteModel;

class SiteController extends ResourceController
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
        parent::__construct();
    }

    public function activateSites()
    {
        $activated = array();
        $pending = $this->site->newQuery()->where('enabled', false)->get();
        foreach ($pending as $site) {
            $result = $this->events->dispatch(new CheckActivatedSite($site));
            if (!is_null($result) and isset($result[0]['result']) and $result[0]['result'] == "SUCCESS") {
                $site->update(['enabled' => true]);
                $activated[] = "$site->subdomain_name";
                event(new ActivatedSite($site));
            }
        }
        return response()->json($activated);
    }


    public function registerAjax(UserRepositoryInterface $users)
    {
        /***
         * Step 1 = Control Reqired Parameters
         * Step 2 = Control Site (Already SubDomain Check)
         * Step 3 = Control User (Already User Check)
         * Step 4 = Create New User
         * Step 5 = Create New Site
         */


        /**
         * Step 1
         */
        $required_field = ['name_surname', 'email', 'subdomain'];
        foreach ($required_field as $field) {
            if (!isset($this->request->$field) or $this->request->$field == "") {
                return $this->responseJSON('error', $field . ' field is required!');
                die;
            }
        }

        $userParameters = array();
        $email = explode('@', $this->request->email);
        $userParameters['email'] = $this->request->email;
        $userParameters['display_name'] = $this->request->name_surname;
        $userParameters['username'] = array_first($email);
        $userParameters['username'] = preg_replace("/[^a-zA-Z0-9]/", "", $userParameters['username']);
        $userParameters['activated'] = 1;
        $userParameters['str_id'] = str_random(24);

        $subdomain = $this->request->subdomain;
        $password = str_random(8);

        /**
         * Step 2
         */
        $isSubdomain = $this->site->findBySubdomain($subdomain);

        if (!is_null($isSubdomain)) {
            return $this->responseJSON('error', 'This subdomain is already exists!');
        }


        /**
         * Step 3
         */
        $isUserByEmail = $this->findUserByColumn('email', $userParameters['email']);
        $isUserByUsername = $this->findUserByColumn('username', $userParameters['username']);

        if (!is_null($isUserByEmail) or !is_null($isUserByUsername)) {
            return $this->responseJSON('error', 'This Username or Email Registered!');

        }

        /**
         * Step 4
         */
        $user = User::query()->create($userParameters);
        $user->setAttribute('password', $password);
        $users->save($user);
        $this->site->createSite($subdomain,$password,$user);
        return $this->responseJSON('success', 'Thank you for Registering!');

    }

    public function responseJSON($type, $message)
    {
        return response()->json(['status' => $type, 'message' => $message]);
    }

    /**
     * @param $column
     * @param $value
     * @return mixed|null
     */
    public function findUserByColumn($column, $value)
    {
        if (!is_null($user = User::withTrashed()->where($column, $value)->get())) {
            return $user->first();
        }
        return null;
    }

}
