<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Jobs\unSuspendSite;


class unSuspend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected, MessageBag $message)
    {
        foreach ($selected as $id) {
            if ($site = $siteRepository->findSuspend($id)) {
                unSuspendSite::dispatch($site);
            }
        }

        if ($selected) {
            $this->messages->success(trans('module::message.send_unsuspend_request',['count' => count($selected)]));
        }    }
}