function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$('.try-demo-openclassify').on('click', function () {
    $('#freetrialForm').modal('toggle');
});

$("#trialForm").submit(function (e) {

    e.preventDefault();

    var formErrors = $('.formErrors');
    var modal = $('#freetrialForm');
    var form = $("#trialForm");
    var email = $(this).find('input[name="email"]').val();
    var name = $(this).find('input[name="name_surname"]').val();
    var storename = $("input[name='storename']").val();
    storename = storename.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');

    /*** Validation Email */
    if (validateEmail(email)) {

        var passthrough = {
            'name_surname': name,
            "email": email,
            'storename': storename
        };

        $.ajax({
            type: 'POST',
            async: false,
            data: passthrough,
            url: '/ajax/registerUser',
            beforeSend: function () {
                modal.find('.loadingSubmit').removeClass('d-none');
            },
            success: function (c) {
                formErrors.html("");
                if (c.status == "success") {
                    modal.modal('hide');
                    $('#created-user-modal').modal('toggle');
                    form.trigger("reset");
                } else {
                    /*** Show Error Icon */
                    $.each(c.type, function (i, t) {
                        if (t === false) {
                            $('.' + i).removeClass('d-none');
                            formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                        } else {
                            if (!$('.' + i).hasClass('d-none')) {
                                $('.' + i).addClass('d-none');
                            }
                        }
                    });
                }
            },
            complete: function () {
                modal.find('.loadingSubmit').addClass('d-none');
            }
        });
    }
});

$('.tryFormOnlyEmail').on('submit', function (e) {
    var modal = $('#freetrialForm');
    e.preventDefault();
    modal.find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
    modal.modal('toggle');
});
