<?php namespace Visiosoft\SiteModule\Site\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class SiteTableButtons
{
    public function handle(SiteTableBuilder $builder)
    {
        $buttons = [
            'log' => [
                'text' => 'visiosoft.module.site::button.show_log',
                'icon' => 'fa fa-code',
                'type' => 'primary',
                'href' => '/admin/jenkins?filter_site={entry.id}'
            ],
            'status' => [
                'attributes' => [
                    'data-toggle' => 'tooltip',
                    'data-placement' => 'top',
                    'title' => function (EntryInterface $entry) {
                        return ($entry->status == "error") ? $entry->message : '';
                    },
                ],
                'text' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return "visiosoft.module.site::button.install_site";
                    } elseif ($entry->status == "completed") {
                        return "visiosoft.module.site::button.active";
                    } elseif ($entry->status == "pending") {
                        return "visiosoft.module.site::button.pending";
                    } else {
                        return "visiosoft.module.site::button.error";
                    }
                },
                'href' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return route('visiosoft.module.site::admin.complete.on.manuel', ['id' => $entry->getId()]);
                    }
                },
                'type' => function (EntryInterface $entry) {
                    if ($entry->status == "completed") {
                        return "success";
                    } elseif ($entry->status == "pending") {
                        return "default";
                    } else {
                        return "warning";
                    }
                },
                'icon' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return "fa fa-credit-card-alt";
                    } elseif ($entry->status == "completed") {
                        return "fa fa-check";
                    } elseif ($entry->status == "pending") {
                        return "fa fa-clock-o";
                    } else {
                        return "fa fa-times";
                    }
                },
            ],
            'settings' => [
                'text' => false,
                'href' => false,
                'dropdown' => [
                    'edit' => [
                        'icon' => false,
                    ],
                    'show-addons' => [
                        'href' => route('visiosoft.module.site::admin.addon.list') . '?filter_subdomain={entry.id}'
                    ],
                    'add-addon' => [
                        'href' => route('visiosoft.module.site::admin.add.addon') . '?site={entry.id}',
                    ],
                    'add-ssl' => [
                        'href' => route('visiosoft.module.site::admin.add.ssl') . '?site={entry.id}',
                    ],
                    'add_domain' => [
                        'href' => route('visiosoft.module.site::admin.domain.create') . '?site={entry.id}',
                    ],
                    'add_bundle' => [
                        'href' => route('visiosoft.module.site::admin.add.bundle') . '?site={entry.id}',
                    ],
                ],
            ],
            'login' => [
                'text' => false,
                'icon' => 'fa fa-key',
                'href' => false,
                'dropdown' => [
                    'login-subdomain' => [
                        'text' => function (EntryInterface $entry) {
                            return trans('visiosoft.module.site::button.login_with_site_url', ['url' => $entry->getUrl()]);
                        },
                        'href' => function (EntryInterface $entry) {
                            return "https://" . $entry->getUrl() . '/auth-auto?token=' . $entry->getToken();
                        },
                    ],
                ],
            ],
        ];

        if (is_module_installed('visiosoft.module.notifications')) {
            $buttons['settings']['dropdown']['send_email'] = [
                'data-toggle' => 'modal',
                'data-target' => '#modal',
                'href' => 'admin/site/choose/{entry.id}',
            ];
        }


        if (is_module_installed('visiosoft.module.subscriptions')) {
            $buttons['settings']['dropdown']['change_plan'] = [
                'data-toggle' => 'modal',
                'data-target' => '#modal',
                'href' => function (EntryInterface $entry) {
                    return route("visiosoft.module.site::choose_plan", ['id' => $entry->id]);
                }
            ];
        }

        $builder->setButtons($buttons);
    }
}
