<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\UpdateSite;


class Update extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        foreach ($selected as $id) {
            if ($site = $siteRepository->find($id)) {
                event(new UpdateSite($site));

                $site->updatedSite();
            }
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.updated', ['count' => count($selected)]));
        }
    }
}