let trial_modal = $('#freetrialForm');

function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$('.try-demo-openclassify').on('click', function () {
    $('#freetrialForm').modal('toggle');
});

$(()=> {
    $("#trialForm, #ocTrialForm").submit(function (e) {
        e.preventDefault();

        let thisForm = $(this).attr('id');
        let formErrors = $('.formErrors');
        let form = $("#" + thisForm);
        let email = $(this).find('input[name="email"]').val();
        let name = $(this).find('input[name="name_surname"]').val();
        let phone = $("input[name='phone']").val();
        let storename = (thisForm === 'ocTrialForm') ?  $("input[name='subdomain']").val() : $("input[name='storename']").val()
        storename = storename.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');

        /*** Validation Email */
        if (validateEmail(email)) {

            var passthrough = {
                'name_surname': name,
                "email": email,
                'storename': storename,
                'phone': phone
            };
            $.ajax({
                type: 'POST',
                data: passthrough,
                url: '/ajax/registerUser',
                beforeSend: function () {
                    trial_modal.find('.loadingSubmit').toggleClass('d-none');
                    trial_modal.find('.submitBtn').prop("disabled", true);
                },
                success: function (c) {
                    formErrors.html("");
                    if (c.status == "success") {

                        //Conversion tracking tag
                        window.dataLayer = window.dataLayer || [];

                        function gtag() {
                            dataLayer.push(arguments);
                        }

                        gtag('js', new Date());
                        gtag('config', 'AW-604648196');

                        gtag('event', 'purchase', {
                            "transaction_id": c.user_id,
                            "value": 0,
                            "currency": "USD",
                        });

                        if (thisForm === 'ocTrialForm') {
                            $('#freeTrialModal').modal('hide')
                            $('#successModal').modal('toggle');
                        } else {
                            trial_modal.modal('hide');
                            $('#created-user-modal').modal('toggle');
                        }

                        form.trigger("reset");
                    } else {
                        /*** Show Error Icon */
                        $.each(c.type, function (i, t) {
                            if (t === false) {
                                $('.' + i).removeClass('d-none');
                                formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                            } else {
                                if (!$('.' + i).hasClass('d-none')) {
                                    $('.' + i).addClass('d-none');
                                }
                            }
                        });
                    }
                },
                complete: function () {
                    trial_modal.find('.submitBtn').prop("disabled", false);
                    trial_modal.find('.loadingSubmit').toggleClass('d-none');
                }
            });
        }
    });
})
$('.tryFormOnlyEmail').on('submit', function (e) {
    e.preventDefault();
    trial_modal.find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
    trial_modal.modal('toggle');
});
