<?php namespace Visiosoft\SiteModule\Site\Table;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Table\Query\DomainFilterQuery;

class SiteTableFilters
{
    public function handle(SiteTableBuilder $builder)
    {
        $filters =  [
            'search' => [
                'fields' => [
                    'subdomain_name',
                ],
            ],
            'domain' => [
                'filter' => 'select',
                'query' => DomainFilterQuery::class,
                'options' => function (DomainRepositoryInterface $domain) {
                    $domains = $domain->newQuery()
                        ->pluck('domain', 'id')
                        ->all();

                    return $domains;
                }
            ],
            'assign' => [
                'filter' => 'select'
            ],
        ];

        $builder->setFilters($filters);
    }
}
