<?php namespace Visiosoft\SiteModule\Site\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class SiteTableColumns
{
    public function handle(SiteTableBuilder $builder)
    {
        $builder->setColumns([
            'subdomain_name' => [
                'value' => function (EntryInterface $entry) {
                    $url = $entry->getUrl();

                    $verify = $entry->verify ? 'fa-check text-success' : 'fa-times text-danger';
                    $ssl = $entry->verify_ssl ? 'fa-lock text-success' : 'fa-unlock-alt text-danger';

                    $link = '<a href="https://' . $url . '" target="_blank">' . $url . '</a><i class="fa ' . $verify . ' pl-1"></i><i class="fa ' . $ssl . '"></i>';

                    if ($entry->suspend_at) {
                        $link = $link . " <i class='fa fa-eye-slash'></i>";
                    }

                    if ($entry->delete_status) {
                        $status = $entry->delete_status == 'pending' ? 'Pending Delete' : 'Error Delete';
                        $link = $link . ' <span class="tag tag-sm tag-danger">' . $status . '</span>';
                    }

                    return $link;
                },
            ],
            'assign' => [
                'value' => function (EntryInterface $entry) {
                    $name = '<span class="text-danger">' . trans('visiosoft.module.site::message.deleted_user') . '</span>';

                    if ($user = $entry->getUser()) {
                        $name = (str_replace(' ', '', $user->name()) === "") ? $user->getDisplayName() : $user->name();
                    }

                    return '<a href="/admin/users/edit/' . $entry->assign_id . '">' . $name . '</a>';
                }
            ],
            'created_at' => [
                'value' => function (EntryInterface $entry) {
                    return (is_null($entry->created_at)) ? "-" : $entry->created_at->format('d/m/Y H:i');
                }
            ],
            'update_at' => [
                'value' => function (EntryInterface $entry) {
                    return (is_null($entry->updated_at)) ? "-" : $entry->updated_at->format('d/m/Y H:i');
                }
            ],
            'domain' => [
                'value' => function (EntryInterface $entry, DomainRepositoryInterface $domain) {
                    $domains = $domain->getDomainsBySite([$entry->id])->pluck('domain')->all();
                    return implode(' , ', $domains);
                },
            ],
        ]);
    }
}
