<?php namespace Visiosoft\SiteModule\Site\Listener\webhook;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\UnSuspendedSite;
use Visiosoft\SiteModule\Site\Event\webhook\ErrorUnsuspendSiteForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;

class RenewedSubscriptionForWebhook
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionRenewedForWebhook $event)
    {
        $subscription = $event->getSubscription();

        $sites = $this->site->getSiteForSubscription($subscription->id);

        foreach ($sites as $site) {
            if (in_array($site->status, ['completed', 'pending']) and $site->suspend_at) {

                $response = array_first(event(new SuspendSite($site, "false")));

                if ($response['status']) {
                    //Unsuspeded Success

                    event(new UnSuspendedSite($site));

                    $site->update([
                        'suspend_at' => null,
                        'deleted_at' => null
                    ]);

                } else {

                    //UnSuspended Failed
                    $site = $site->update(['message' => $response['message']]);

                    event(new ErrorUnsuspendSiteForWebhook($site));
                }
            }
        }
    }
}
