<?php namespace Visiosoft\SipayExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\SipayExtension\Commands\Cards;
use Visiosoft\SipayExtension\Commands\Invoice;
use Visiosoft\SipayExtension\Commands\Items;
use Visiosoft\SipayExtension\Commands\Pay;

class SipayExtension extends Extension
{
    protected $provides = 'visiosoft.module.payment::payment_provider.sipay';

    protected string $successCallback;
    protected string $failCallback;

    public function setSuccessCallback(string $callback) {
        $this->successCallback = $callback;
    }

    public function setFailCallback(string $callback) {
        $this->failCallback = $callback;
    }

    public function payByIframe(
        $card_number,
        $card_holder,
        $exp_year,
        $exp_month,
        $cvv,
        $total,
        $items,
        $currency,
        $invoice_id,
        $buyer_name,
        $buyer_surname) {

        try {
            // Since this process starts the Auth process, it must be called first.
            $connector = new \Visiosoft\SipayExtension\Commands\Connector();

            $card = new Cards();
            $card->createCard($card_number, $card_holder, $exp_year, $exp_month, $cvv);
            $card->createCard($card_number, $card_holder, $exp_year, $exp_month, $cvv);

            $sipay_items = new Items();
            foreach ($items as $item) {
                $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
            }

            $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname);

            $pay = new Pay($card, $total,$sipay_items, $connector, $invoice, $currency);
            $result_pay = $pay->pay3D();

            if ($result_pay['status'] == "success") {
                $serviceResponse['status'] = 'success';
                $serviceResponse['payment_redirect_uri'] = route('visiosoft.extension.payment_sipay::iframe', ['response' => $result_pay]);
            } else {
                $serviceResponse['status'] = 'fail';
                $serviceResponse['service_message'] = 'Payment Error';
            }

        } catch (\Exception $e) {

            $this->logError($e);
            $serviceResponse['status'] = 'fail';
            $serviceResponse['service_message'] = "Payment Error";

        }

        return $serviceResponse;
    }

    public function payByCard(
        $card_number,
        $card_holder,
        $exp_year,
        $exp_month,
        $cvv,
        $total,
        $items,
        $currency,
        $invoice_id,
        $buyer_name,
        $buyer_surname) {

        try {
            // Since this process starts the Auth process, it must be called first.
            $connector = new \Visiosoft\SipayExtension\Commands\Connector();

            $card = new Cards();
            $card->createCard($card_number, $card_holder, $exp_year, $exp_month, $cvv);
            $card->createCard($card_number, $card_holder, $exp_year, $exp_month, $cvv);

            $sipay_items = new Items();
            foreach ($items as $item) {
                $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
            }

            $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname);

            $pay = new Pay($card, $total,$sipay_items, $connector, $invoice, $currency);
            $result_pay = $pay->pay3D();

            if ($result_pay['status'] == "success") {
                $serviceResponse['status'] = 'success';
                $serviceResponse['payment_redirect_uri'] = route('visiosoft.extension.payment_sipay::iframe', ['response' => $result_pay['response']]);
            } else {
                $serviceResponse['status'] = 'fail';
                $serviceResponse['service_message'] = 'Payment Error';
            }

        } catch (\Exception $e) {

            $this->logError($e);
            $serviceResponse['status'] = 'fail';
            $serviceResponse['service_message'] = "Payment Error";

        }

        return $serviceResponse;
    }

    /*
     * Logging errors to storage folder
     *
     * params: $error
     * return: void
     */
    public function logError($error)
    {
        $log = new Logger('sipay');
        $log->pushHandler(new StreamHandler(storage_path('logs/sipay.log')), Logger::ERROR);
        $log->error($error);
    }
}
