<?php namespace Visiosoft\SipayExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Collection;
use Visiosoft\SipayExtension\Commands\Connector;

class SipayController extends PublicController
{
    private $connector;

    public function __construct(Connector $connector)
    {
        parent::__construct();
        $this->connector = $connector;
    }

    public function paymentReturn()
    {
        $response = request()->get('response');
        return view('visiosoft.extension.sipay::iframe', compact('response'));
    }

    public function paymentCallback()
    {
        $response = request()->all();
        $order_id = $response['invoice_id'];
        $status = new Collection();

        $status->offsetSet('invoice_id', $order_id);
        $status->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $status->offsetSet('include_pending_status', true);

        $this->connector->responseBuilder($this->connector->service('api/checkstatus', $status->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
        ]));

        $statusResponse = $this->connector->getResponse();

        return $this->paymentResponse($statusResponse, $response['invoice_id']);
    }

    public function paymentResponse($statusResponse, $order_id)
    {

        if ($statusResponse['status_code'] == 100) {
            $this->messages->success('visiosoft.extension.sipay::message.success');
            $status = true;
        } else {
            $this->messages->error('visiosoft.extension.sipay::message.error');
            $status = false;
        }

        if (is_module_installed('visiosoft.module.orders')) {
            $orderRepo = app('Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface');
            $status ? $orderRepo->approveOrder($order_id) : $orderRepo->rejectOrder($order_id);
        }

        return $this->redirect->to('/purchase/detail/' . $order_id);
    }
}
