<?php namespace Visiosoft\SipayExtension\Commands;

use Illuminate\Support\Collection;

class Pay
{
    protected $cards;
    protected $total;
    protected $items;
    protected $connector;
    protected $invoice;
    protected $currency;
    protected $installment;

    public function __construct(Cards $cards, $total, Items $items, Connector $connector, Invoice $invoice, $currency = 'TRY', $installment = 1)
    {
        $this->cards = $cards;
        $this->total = $total;
        $this->items = $items;
        $this->connector = $connector;
        $this->invoice = $invoice;
        $this->currency = $currency;
        $this->installment = $installment;
    }

    public function getItems()
    {
        return $this->items->getItems();
    }

    public function pay2D()
    {
        // Create Attribute Collection
        $payment = new Collection();

        // Set Card Informations
        $payment->offsetSet('cc_holder_name', $this->cards->getCCHolderName());
        $payment->offsetSet('cc_no', $this->cards->getCCNumber());
        $payment->offsetSet('expiry_month', $this->cards->getExpMonth());
        $payment->offsetSet('expiry_year', $this->cards->getExpYear());
        $payment->offsetSet('cvv', $this->cards->getCVV());

        // Set Items
        $payment->offsetSet('items', $this->items->getItems());

        // Set Invoice
        $payment->offsetSet('invoice_id', $this->invoice->getInvoiceID());
        $payment->offsetSet('invoice_description', $this->invoice->getInvoiceDescription());
        $payment->offsetSet('name', $this->invoice->getBuyerName());
        $payment->offsetSet('surname', $this->invoice->getBuyerSurname());

        // Other Attributes
        $payment->offsetSet('installments_number', $this->installment);
        $payment->offsetSet('total', $this->getTotal());
        $payment->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $payment->offsetSet('hash_key', $this->generateHash());
        $payment->offsetSet('currency_code', $this->currency);

        $this->connector->responseBuilder($this->connector->service('api/paySmart2D', $payment->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
        ]));

        return $this->connector->getResponse();
    }

    public function getTotal()
    {
        return $this->total;
    }

    protected function generateHash()
    {
        $data = $this->getTotal() . '|' . $this->installment . '|' . $this->currency . '|' . $this->connector->getMerchantKey() . '|' . $this->invoice->getInvoiceID();

        $iv = substr(sha1(mt_rand()), 0, 16);
        $password = sha1($this->connector->getAppSecret());

        $salt = substr(sha1(mt_rand()), 0, 4);
        $saltWithPassword = hash('sha256', $password . $salt);

        $encrypted = openssl_encrypt("$data", 'aes-256-cbc', "$saltWithPassword", null, $iv);

        $msg_encrypted_bundle = "$iv:$salt:$encrypted";
        $msg_encrypted_bundle = str_replace('/', '__', $msg_encrypted_bundle);

        return $msg_encrypted_bundle;
    }

    public function confirm()
    {
        // Confirm Attribute Collection
        $confirm = new Collection();

        $confirm->offsetSet('invoice_id', $this->invoice->getInvoiceID());
        $confirm->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $confirm->offsetSet('status', 1);
        $confirm->offsetSet('hash_key', $this->generateHash());
        $confirm->offsetSet('total', $this->getTotal());

        $this->connector->responseBuilder($this->connector->service('api/confirmPayment', $confirm->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
        ]));

        return $this->connector->getResponse();
    }

    public function pay3D()
    {
        $invoice_id = $this->invoice->getInvoiceID(); // merchant invoice id
        $currency_code = "TRY"; //Merchant currency code e.g(TRY,USD,EUR)
        $total = $this->getTotal();


        $item_js = json_encode($this->items->getItems());

        $name = $this->invoice->getBuyerName();
        $surname = $this->invoice->getBuyerSurname();
        $sale_web_hook = '';//put your web hook
        $installment = $this->installment;


        $hash_key = $this->generateHashKey($total, $installment, $currency_code,
            $this->connector->getMerchantKey(), $invoice_id, $this->connector->getAppSecret());

        $invoice = [
            'merchant_key' => $this->connector->getMerchantKey(),
            'invoice_id' => $invoice_id,
            'total' => $total,
            'items' => $item_js,
            'currency_code' => $currency_code,
            'cc_holder_name' => $this->cards->getCCHolderName(),
            'cc_no' =>  $this->cards->getCCNumber(),
            'expiry_month' => $this->cards->getExpMonth(),
            'expiry_year' => $this->cards->getExpYear(),
            'cvv' =>  $this->cards->getCVV(),
            'installments_number' => $installment,
            'cancel_url' => route('visiosoft.extension.payment_sipay::callback', ['response' => 'fail']),
            'return_url' => route('visiosoft.extension.payment_sipay::callback', ['response' => 'success']),
            'hash_key' => $hash_key,
            'name' => $name,
            'surname' => $surname,
        ];

        //billing info
        $invoice['bill_address1'] = 'Address 1 should not more than 100'; //should not more than 100 characters
        $invoice['bill_address2'] = 'Address 2'; //should not more than 100 characters
        $invoice['bill_city'] = 'Istanbul';
        $invoice['bill_postcode'] = '1111';
        $invoice['bill_state'] = 'Istanbul';
        $invoice['bill_country'] = 'TURKEY';
        $invoice['bill_phone'] = '008801777711111';
        $invoice['bill_email'] = 'info@openclassify.com.tr';
        $invoice['sale_web_hook_key'] = $sale_web_hook;


        $formOpen = "<form action='".$this->connector->getUrl()."ccpayment/api/paySmart3D' method='post' id='the-form'>";

        $form = '';
        foreach ($invoice as $key => $value){
            $form .= "<input type='hidden' name='{$key}' value='{$value}'>";
        }

        $formClose = "</form>";
        $script ='<script type="text/javascript">window.onload = function(){
                        document.getElementById("the-form").submit();}
                  </script>';

        return [
            'status' => 'success',
            'response' => $formOpen.$form.$formClose.$script
        ];
    }
    // todo hash generate inside connector is not works properly.
    // this will be removed after the function inside extension is fixed
    private function generateHashKey($total, $installment, $currency_code, $merchant_key,  $invoice_id, $app_secret){

        $data = $total.'|'.$installment.'|'.$currency_code.'|'.$merchant_key.'|'.$invoice_id;

        $iv = substr(sha1(mt_rand()), 0, 16);
        $password = sha1($app_secret);

        $salt = substr(sha1(mt_rand()), 0, 4);
        $saltWithPassword = hash('sha256', $password . $salt);

        $encrypted = openssl_encrypt(
            "$data", 'aes-256-cbc', "$saltWithPassword", null, $iv
        );
        $msg_encrypted_bundle = "$iv:$salt:$encrypted";
        $msg_encrypted_bundle = str_replace('/', '__', $msg_encrypted_bundle);
        return $msg_encrypted_bundle;
    }
}
