<?php namespace Visiosoft\SipayExtension\Commands;

use GuzzleHttp\Client;

class Connector
{
    protected $app_id;
    protected $merchant_id;
    protected $app_secret;
    protected $merchant_key;

    protected $live = false;

    protected $url = null;

    protected $response = null;
    protected $sandbox_url = 'https://provisioning.sipay.com.tr/ccpayment/';
    protected $live_url = 'https://app.sipay.com.tr/ccpayment/';

    protected $token = null;

    public function __construct()
    {
        $this->app_id = config('sipay::app_id');
        $this->app_secret = config('sipay::app_secret');
        $this->merchant_id = config('sipay::merchant_id');
        $this->merchant_key = config('sipay::merchant_key');
        $this->live = config('sipay::live', false);

        if (!$this->app_id || !$this->app_secret || !$this->merchant_id || !$this->merchant_key) {
            throw new \Exception('The app_id, app_secret, merchant_key and merchant_id values are required.', 500);
        }

        $this->url = ($this->live) ? $this->live_url : $this->sandbox_url;

        $this->token = $this->setToken();
    }

    public function getToken()
    {
        return $this->token;
    }

    public function getMerchantKey()
    {
        return $this->merchant_key;
    }

    public function getAppSecret()
    {
        return $this->app_secret;
    }

    private function getAppID()
    {
        return $this->app_id;
    }

    public function getUrl($suffix = '')
    {
        return $this->url . $suffix;
    }

    private function setToken()
    {
        $this->responseBuilder($this->service('api/token', array('app_id' => $this->getAppID(), 'app_secret' => $this->getAppSecret())));

        return $this->getResponseAttribute('token');
    }

    public function setResponse($response)
    {
        $this->response = $response;
    }

    public function getResponse()
    {
        return $this->response;
    }

    public function service($service_path, $params, $method = 'POST', $headers = [])
    {
        $client = new Client([
            'verify' => false,
        ]);

        try {

            $response = $client->request($method, $this->getUrl($service_path), ['json' => $params,'headers' => $headers]);

        } catch (\Exception $e) {

            return $e->getMessage();

        }

        if ($response->getStatusCode() != '200') {
            throw new \Exception(trans('streams::error.500.name'));
        }


        $content = $response->getBody()->getContents();
        if ($this->is_json_string($content)) {
            $response_values = json_decode($content, true);
        } else {
            $response_values = array_merge(['data' => $content], ['status_description' => 'Form returned successfully','status_code' => 100]);
        }

        return $response_values;
    }

    public function responseBuilder($response)
    {
        $this->setResponse($response['data'] ?? $response);
    }

    public function getResponseAttribute($key)
    {
        return array_value($this->getResponse(), $key);
    }

    public function is_json_string($json_str)
    {
        json_decode($json_str);
        return json_last_error() === 0;
    }
}
