<?php namespace Visiosoft\SipayExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\SipayExtension\Commands\Cards;
use Visiosoft\SipayExtension\Commands\Invoice;
use Visiosoft\SipayExtension\Commands\Items;
use Visiosoft\SipayExtension\Commands\Pay;
use Visiosoft\SipayExtension\Commands\PayBySavedCard;

class SipayExtension extends Extension
{
    protected $provides = 'visiosoft.module.payment::payment_provider.sipay';

    public function pay($cc_no, $cc_holder_name, $exp_year, $exp_month, $cvv, $total, $items, $currency, $invoice_id, $buyer_name, $buyer_surname)
    {
        // Since this process starts the Auth process, it must be called first.
        $connector = new \Visiosoft\SipayExtension\Commands\Connector();

        $card = new Cards();
        $card->createCard($cc_no, $cc_holder_name, $exp_year, $exp_month, $cvv);

        $sipay_items = new Items();
        foreach ($items as $item) {
            $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
        }

        $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname);

        $pay = new Pay($card, $total,$sipay_items, $connector, $invoice, $currency);
        $result_pay = $pay->pay2D();

        if ($result_pay['payment_status'] == 1) {
            if ($result_pay["transaction_type"] == "Auth") {
                // Payment Success
                return true;
            } else if ($result_pay["transaction_type"] == "Pre-Authorization") {
                //  /api/confirmPayment
                $pay->confirm();

                return true;
            }
        } else {
            // payment_status == 0
            return false;
        }
    }

    public function payWithSaved($card_token, $items, $currency, $invoice_id, $buyer_name, $buyer_surname, $buyer_phone, $buyer_email, $buyer_id)
    {
        // Since this process starts the Auth process, it must be called first.
        $connector = new \Visiosoft\SipayExtension\Commands\Connector();

        $sipay_items = new Items();
        foreach ($items as $item) {
            $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
        }

        $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname, '', $buyer_phone, $buyer_email, $buyer_id);

        $pay = new PayBySavedCard($card_token, $sipay_items, $connector, $invoice, $currency);
        $result_pay = $pay->payByCardToken();

        dd($result_pay);
    }
}
