<?php namespace Visiosoft\SipayExtension\Commands;

use Illuminate\Support\Collection;

class PayBySavedCard
{
    protected $cardToken;
    protected $items;
    protected $connector;
    protected $invoice;
    protected $currency;
    protected $installment;

    public function __construct($cardToken, Items $items, Connector $connector, Invoice $invoice, $currency = 'TRY', $installment = 1)
    {
        $this->cardToken = $cardToken;
        $this->items = $items;
        $this->connector = $connector;
        $this->invoice = $invoice;
        $this->currency = $currency;
        $this->installment = $installment;
    }

    public function getItems()
    {
        return $this->items->getItems();
    }

    public function getTotal()
    {
        $total = 0;
        foreach ($this->getItems() as $item) {
            $total += $item['price'];
        }

        return $total;
    }

    protected function generateHash()
    {
        $data = $this->getTotal() . '|' . $this->installment . '|' . $this->currency . '|' . $this->connector->getMerchantKey() . '|' . $this->invoice->getInvoiceID();

        $iv = substr(sha1(mt_rand()), 0, 16);
        $password = sha1($this->connector->getAppSecret());

        $salt = substr(sha1(mt_rand()), 0, 4);
        $saltWithPassword = hash('sha256', $password . $salt);

        $encrypted = openssl_encrypt("$data", 'aes-256-cbc', "$saltWithPassword", null, $iv);

        $msg_encrypted_bundle = "$iv:$salt:$encrypted";
        $msg_encrypted_bundle = str_replace('/', '__', $msg_encrypted_bundle);

        return $msg_encrypted_bundle;
    }

    public function payByCardToken()
    {
        $pay_by_cardToken = new Collection();

        $pay_by_cardToken->offsetSet('card_token', $this->cardToken);
        $pay_by_cardToken->offsetSet('currency_code', $this->currency);
        $pay_by_cardToken->offsetSet('installments_number', $this->installment);
        $pay_by_cardToken->offsetSet('total', $this->getTotal());
        $pay_by_cardToken->offsetSet('invoice_id', $this->invoice->getInvoiceID());
        $pay_by_cardToken->offsetSet('invoice_description', $this->invoice->getInvoiceDescription());
        $pay_by_cardToken->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $pay_by_cardToken->offsetSet('name', $this->invoice->getBuyerName());
        $pay_by_cardToken->offsetSet('surname', $this->invoice->getBuyerSurname());
        $pay_by_cardToken->offsetSet('hash_key', $this->generateHash());

        // Set Items
        $pay_by_cardToken->offsetSet('items', $this->items->getItems());

        // Set Callback URL
        $pay_by_cardToken->offsetSet('return_url', url('sipay/payment/return?status=true'));
        $pay_by_cardToken->offsetSet('cancel_url', url('sipay/payment/return?status=false'));

        // Set Customer Detail
        $pay_by_cardToken->offsetSet('customer_number', $this->invoice->getBuyerID());
        $pay_by_cardToken->offsetSet('customer_email', $this->invoice->getBuyerEmail());
        $pay_by_cardToken->offsetSet('customer_phone', $this->invoice->getBuyerPhone());
        $pay_by_cardToken->offsetSet('customer_name', $this->invoice->getBuyerName());

        $this->connector->responseBuilder($this->connector->service('api/payByCardToken', $pay_by_cardToken->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
        ]));

        return $this->connector->getResponse();
    }
}
