<?php namespace Visiosoft\SipayExtension\Commands;

use Illuminate\Support\Collection;

class Pay
{
    protected $cards;
    protected $total;
    protected $items;
    protected $connector;
    protected $invoice;
    protected $currency;
    protected $installment;

    public function __construct(Cards $cards, $total, Items $items, Connector $connector, Invoice $invoice, $currency = 'TRY', $installment = 1)
    {
        $this->cards = $cards;
        $this->total = $total;
        $this->items = $items;
        $this->connector = $connector;
        $this->invoice = $invoice;
        $this->currency = $currency;
        $this->installment = $installment;
    }

    public function getItems()
    {
        return $this->items->getItems();
    }

    public function pay2D()
    {
        // Create Attribute Collection
        $payment = new Collection();

        // Set Card Informations
        $payment->offsetSet('cc_holder_name', $this->cards->getCCHolderName());
        $payment->offsetSet('cc_no', $this->cards->getCCNumber());
        $payment->offsetSet('expiry_month', $this->cards->getExpMonth());
        $payment->offsetSet('expiry_year', $this->cards->getExpYear());
        $payment->offsetSet('cvv', $this->cards->getCVV());

        // Set Items
        $payment->offsetSet('items', $this->items->getItems());

        // Set Invoice
        $payment->offsetSet('invoice_id', $this->invoice->getInvoiceID());
        $payment->offsetSet('invoice_description', $this->invoice->getInvoiceDescription());
        $payment->offsetSet('name', $this->invoice->getBuyerName());
        $payment->offsetSet('surname', $this->invoice->getBuyerSurname());

        // Other Attributes
        $payment->offsetSet('installments_number', $this->installment);
        $payment->offsetSet('total', $this->getTotal());
        $payment->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $payment->offsetSet('hash_key', $this->generateHash());
        $payment->offsetSet('currency_code', $this->currency);

        $this->connector->responseBuilder($this->connector->service('api/paySmart2D', $payment->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
        ]));

        return $this->connector->getResponse();
    }

    public function getTotal()
    {
        return $this->total;
    }

    protected function generateHash()
    {
        $data = $this->getTotal() . '|' . $this->installment . '|' . $this->currency . '|' . $this->connector->getMerchantKey() . '|' . $this->invoice->getInvoiceID();

        $iv = substr(sha1(mt_rand()), 0, 16);
        $password = sha1($this->connector->getAppSecret());

        $salt = substr(sha1(mt_rand()), 0, 4);
        $saltWithPassword = hash('sha256', $password . $salt);

        $encrypted = openssl_encrypt("$data", 'aes-256-cbc', "$saltWithPassword", null, $iv);

        $msg_encrypted_bundle = "$iv:$salt:$encrypted";
        $msg_encrypted_bundle = str_replace('/', '__', $msg_encrypted_bundle);

        return $msg_encrypted_bundle;
    }

    public function confirm()
    {
        // Confirm Attribute Collection
        $confirm = new Collection();

        $confirm->offsetSet('invoice_id', $this->invoice->getInvoiceID());
        $confirm->offsetSet('merchant_key', $this->connector->getMerchantKey());
        $confirm->offsetSet('status', 1);
        $confirm->offsetSet('hash_key', $this->generateHash());
        $confirm->offsetSet('total', $this->getTotal());

        $this->connector->responseBuilder($this->connector->service('api/confirmPayment', $confirm->toArray(), 'POST', [
            'Authorization' => 'Bearer ' . $this->connector->getToken(),
        ]));

        return $this->connector->getResponse();
    }
}
