<?php namespace Visiosoft\SinargeTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;


class RepeaterSeeder extends Seeder
{
    protected $streamRepository;
    protected $fieldsRepository;
    protected $assignmentsRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldsRepository,
        AssignmentRepositoryInterface $assignmentsRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fieldsRepository = $fieldsRepository;
        $this->assignmentsRepository = $assignmentsRepository;
    }

    public function run()
    {
        //Collect repeater
        $repeaters = [
            'Showcase Page' => [
                'content' => [
                    'name' => 'Showcase Page',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_page',
                    'translatable' => true,
                ],
                'fields' => ['showcase_image', 'header_text', 'info_text']
            ],
        ];

        // Collect Repeater Fields
        $repeater_fields = [
            'Showcase Image' => [
                'field_attributes' => [
                    'name' => 'Showcase Image',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_image',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => false,
                ]
            ],
            'header_text' => [
                'field_attributes' => [
                    'name' => 'Header Text',
                    'namespace' => 'repeater',
                    'slug' => 'header_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                ],
                'assignment_attributes' => [
                    'required' => false,
                    'translatable' => true,
                ]
            ],
            'info_text' => [
                'field_attributes' => [
                    'name' => 'Info Text',
                    'namespace' => 'repeater',
                    'slug' => 'info_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                ],
                'assignment_attributes' => [
                    'required' => false,
                    'translatable' => true,
                ]
            ],

        ];

        foreach ($repeaters as $slug => $repeater) {
            if (!$repeater_stream = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater_stream = $this->streamRepository->create($repeater['content']);
            }

            foreach ($repeater_fields as $field_slug => $field_repeater) {
                if (!$field = $this->fieldsRepository->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fieldsRepository->create($field_repeater['field_attributes']);
                }

                if (!$this->assignmentsRepository->findByStreamAndField($repeater_stream, $field)) {
                    $this->assignmentsRepository->create(
                        array_merge([
                            'stream' => $repeater_stream,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }
    }
}