<?php namespace Visiosoft\SimpleClassifiedModule\Product\Form;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Illuminate\Http\Request;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\Integration\IntegrateProductToTrendyol;
use Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\Integration\UpdateProductOnTrendyol;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Message\MessageBag;


class EditAllInOneFormHandler extends AdminController
{
    public function handle(EditAllInOneFormBuilder $builder, AdvRepositoryInterface $advRepository, MessageBag $messages)
    {   
        // Get or calculate all necessary form fields

        $all = $this->request->all();

        $locale = config('streams::locales.enabled');

        $translatable = array();
        foreach ($all as $key => $value) {
            foreach ($locale as $lang) {
                if ($this->endsWith($key, "_$lang") && !in_array(substr($key, 0, -3), $translatable)) {
                    $translatable[] = substr($key, 0, -3);
                }
            }
        }

        $translatableEntries = array();
        foreach ($locale as $lang) {
            $translatableEntries[$lang] = array();
            foreach ($translatable as $translatableEntry) {
                $translatableEntries[$lang][$translatableEntry] = $all[$translatableEntry . '_' . $lang];
            }
        }

        $unTranslatableFields = [
            'slug' => $builder->getFormValue('slug'),
            'cat1' => $builder->getFormValue('cat1'),
            'cat2' => $builder->getFormValue('cat2'),
            'price' => $builder->getFormValue('price'),
            'currency' => $builder->getFormValue('currency'),
            'is_get_adv' => $builder->getFormValue('is_get_adv'),
            'stock' => $builder->getFormValue('stock'),
            'status' => $builder->getFormValue('status'),
            'standard_price' => $builder->getFormValue('standard_price'),
            'tax' => $builder->getFormValue('tax'),
        ];

        $allFields = array_merge($translatableEntries, $unTranslatableFields);
    
        // Update relevant advs with the form fields above

        $productToBeUpdated = $advRepository->find($builder->getEntry());

        $productToBeUpdated->files = $builder->getFormValue('files');

        $productToBeUpdated->update($allFields);

        if ($builder->getFormValue('trendyol')) {
            $updater = new UpdateProductOnTrendyol();

            $updater->updateProduct($productToBeUpdated, $builder, $messages);
        }

    }

    public function endsWith($string, $test)
    {
        $strlen = strlen($string);
        $testlen = strlen($test);
        if ($testlen > $strlen) return false;
        return substr_compare($string, $test, $strlen - $testlen, $testlen) === 0;
    }
}
