<?php namespace Visiosoft\SimpleClassifiedModule\Product\Form;

use Visiosoft\AdvsModule\Adv\AdvRepository;
use Illuminate\Http\Request;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\Integration\IntegrateProductToTrendyol;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\AdvsModule\OptionConfiguration\OptionConfigurationRepository;
use Visiosoft\AdvsModule\ProductoptionsValue\ProductoptionsValueRepository;

class AllInOneFormHandler extends AdminController
{
    public $entry;

    public function handle(AllInOneFormBuilder $builder, MessageBag $messages)
    {       
        // dd( json_decode( $builder->getFormValue('variationValues'), true ) );
        
        $all = $this->request->all();

        $locale = config('streams::locales.enabled');

        $translatable = array();
        foreach ($all as $key => $value) {
            foreach ($locale as $lang) {
                if ($this->endsWith($key, "_$lang") && !in_array(substr($key, 0, -3), $translatable)) {
                    $translatable[] = substr($key, 0, -3);
                }
            }
        }

        $translatableEntries = array();
        foreach ($locale as $lang) {
            $translatableEntries[$lang] = array();
            foreach ($translatable as $translatableEntry) {
                $translatableEntries[$lang][$translatableEntry] = $all[$translatableEntry . '_' . $lang];
            }
        }

        $unTranslatableFields = [
            'slug' => $builder->getFormValue('slug'),
            'cat1' => $builder->getFormValue('cat1'),
            'cat2' => $builder->getFormValue('cat2'),
            'price' => $builder->getFormValue('price'),
            'currency' => $builder->getFormValue('currency'),
            'is_get_adv' => $builder->getFormValue('is_get_adv'),
            'stock' => $builder->getFormValue('stock'),
            'status' => $builder->getFormValue('status'),
            'standard_price' => $builder->getFormValue('standard_price'),
            'tax' => $builder->getFormValue('tax'),
        ];

        $allFields = array_merge($translatableEntries, $unTranslatableFields);

        $advs = app(AdvRepository::class);

        $createdAdv = $advs->create($allFields);

        $createdAdv->files = $builder->getFormValue('files');

        // save variation related data to database

        $variationValuesJson = $builder->getFormValue('variationValues');

        if ( !is_null($variationValuesJson) ) {
            $variationValues = json_decode($variationValuesJson, true);
            $variants = $variationValues['variants'];

            $optionIds = [];

            foreach ($variants as $variant) {
                $configurations = app(OptionConfigurationRepository::class);
                $configurations->create([
                    'parent_adv_id' => $createdAdv->id,
                    'price' => $variant['price'],
                    'currency' => $createdAdv->currency,
                    'stock' => $variant['stock'],
                    'option_json' => json_encode( (object) $variant['options'] ),
                ]);           
                
                foreach ($variant['options'] as $variationId => $variantId) {
                    array_push($optionIds, $variantId);
                }
            }

            $createdAdv->product_options_value = $optionIds;
        }

        // integration

        if ($builder->getFormValue('trendyol')) {
            $integrateProductToTrendyol = new IntegrateProductToTrendyol();

            $integrateProductToTrendyol->integrate($createdAdv, $builder, $messages);
        }
    }

    // helper function

    public function endsWith($string, $test)
    {
        $strlen = strlen($string);
        $testlen = strlen($test);
        if ($testlen > $strlen) return false;
        return substr_compare($string, $test, $strlen - $testlen, $testlen) === 0;
    }
}
