<?php namespace Visiosoft\SimpleClassifiedModule\Http\Controller\Admin;

use Illuminate\Support\Facades\Auth;
use Visiosoft\SimpleClassifiedModule\Product\Form\AllInOneFormBuilder;
use Visiosoft\SimpleClassifiedModule\Product\Form\EditAllInOneFormBuilder;
use Visiosoft\SimpleClassifiedModule\Product\Table\AllInOneTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvRepository;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;

class ProductsController extends AdminController
{
    private $adv_model;

    public function __construct(
        AdvModel $advModel
    )
    {
        $this->adv_model = $advModel;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param ProductTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AllInOneTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ProductFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(AllInOneFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ProductFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(EditAllInOneFormBuilder $form, $id)
    {
        return $this->view->make('visiosoft.module.simple_classified::admin/products/editProduct', compact('id'));
    }

    public function delete($id)
    {
        $ad = $this->adv_model->find($id);
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        // dd($ad);

        $ad->delete();
        return back();
    }
}
