<?php namespace Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateModel;

class EditCategoryTemplateFormBuilder extends FormBuilder
{
    protected $model = CategoryTemplateModel::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        '*',
        'category_ids' => [
            'type' => 'anomaly.field_type.text',        
        ],
        'template_choice' => [
            'type' => 'anomaly.field_type.select',
            "config" => [
                "mode" => "radio",
            ],            
        ],
        'template_name' => [
            'type' => 'anomaly.field_type.text'
        ],
        'price_percentageChange' => [
            'type' => 'anomaly.field_type.integer'
        ],
        'rounding_method' => [
            'type' => 'anomaly.field_type.select'
        ],
        'discount_policy' => [
            'type' => 'anomaly.field_type.select'
        ],
        'discount_type' => [
            'type' => 'anomaly.field_type.select'
        ],
        'discount_value' => [
            'type' => 'anomaly.field_type.integer'
        ],
        'trendyol_cargoCompany' => [
            'type' => 'anomaly.field_type.text'
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'update',
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'visiosoft.module.simple_classified::css/category-templates.css',
        ],            
    ];

}
