<?php namespace Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form;

use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateRepository;

class CategoryTemplateFormHandler
{
    public function handle(CategoryTemplateFormBuilder $builder)
    {           
        $categoriesToBeTemplated = json_decode( $builder->getFormValue('category_ids') );

        $categoryTemplates = app(CategoryTemplateRepository::class);

        if ( $builder->getFormValue('template_choice') ==  "new_template") {
            $categoryTemplate = $categoryTemplates->create([
                'oc_categoryIds' => json_encode($categoriesToBeTemplated),
                'trendyol_packageAttributes' => json_encode([
                     'template_name' => $builder->getFormValue('template_name'),
                     'price_percentageChange' => $builder->getFormValue('price_percentageChange'),
                     'rounding_method' => $builder->getFormValue('rounding_method'),
                     'discount_policy' => $builder->getFormValue('discount_policy'),
                     'discount_type' => $builder->getFormValue('discount_type'),
                     'discount_value' => $builder->getFormValue('discount_value'),
                     'cargoCompany' => $builder->getFormValue('trendyol_cargoCompany'),
                ]),
            ]);
        }
    }
}
