let currentUrl = window.location.href;

function get_trendyol_CategoryAttributes(categoryId) {
    $("#category_attributes_container").html('');
    $.ajax({
        url: `/admin/getProductInformation/categoryAttributes/${categoryId}`,
        dataType: "json",
        success: function(categoryAttributes) {
            if (currentUrl.includes('matchCategories')) {
                matchAttributes(categoryAttributes);
            }

            specifyCategoryAttributes(categoryAttributes);            
        }
    });
}

function specifyCategoryAttributes(categoryAttributes) {
    let specifiedAttributes;
    if (currentUrl.includes('edit')) {
        specifiedAttributes = JSON.parse($("#category_attributes_container").attr('attributevalues'));
    }

    let attributeInputFields = document.createElement("div");
    attributeInputFields.className = "form-group container";

    let row = document.createElement("div");
    row.className = "row";

    attributeInputFields.insertAdjacentElement('afterbegin', row);

    function compareNecessaryStatus(a, b) {
        if (a.required > b.required) return -1;
        if (a.required == b.required) return 0;
        if (a.required < b.required) return 1;
    }

    categoryAttributes.categoryAttributes.sort(compareNecessaryStatus);

    for (let categoryAttribute of categoryAttributes.categoryAttributes) {
        let specifiedAttribute;
        if (currentUrl.includes('edit')) {
            specifiedAttribute = specifiedAttributes.find(specifiedAttributeItem => specifiedAttributeItem.attributeId == categoryAttribute.attribute.id);
        }

        let options = ``;
        for (let value of categoryAttribute.attributeValues) {
            if (typeof specifiedAttribute !== 'undefined') {
                options += `<option ${value.id == specifiedAttribute.attributeValueId ? 'selected' : ''} value="${value.id}">${value.name}</option>`;
            } else {
                options += `<option value="${value.id}">${value.name}</option>`;
            }
        }

        if (categoryAttribute.allowCustom) {
            if (typeof specifiedAttribute !== 'undefined') {                
                row.innerHTML += generateCategoryRow(categoryAttribute.attribute.name, categoryAttribute.attribute.id, categoryAttribute.required, specifiedAttribute.customAttributeValue);
            } else {
                row.innerHTML += generateCategoryRow(categoryAttribute.attribute.name,categoryAttribute.attribute.id,categoryAttribute.required);
            }
        } else {            
            row.innerHTML += generateSelectForAttributes(categoryAttribute.attribute.name, categoryAttribute.required, categoryAttribute.attribute.id, options);
        }
    }

    // if the product has variations structure category attributes form

    if ($("#is_variation").is(":checked")) {
        let variantList = ``;
        let tabContents = ``;
    
        let variantCount = document.getElementById('variant_count').value;
    
        for (let i = 1; i <= variantCount; i++) {
            variantList += `
                <li class="nav-item ${i == 1 ? 'active' : ''}">
                    <a class="nav-link ${i == 1 ? 'active' : ''}" id="variant${i}-tab" data-toggle="tab" href="#variant${i}" role="tab" aria-controls="variant${i}" aria-selected="false">Variant ${i}</a>
                </li>
            `;
            tabContents += `
                <div class="tab-pane fade ${i == 1 ? 'active in' : ''}" id="variant${i}" role="tabpanel" aria-labelledby="variant${i}-tab">
                    <form name="category_attributes${i}" id="form-variant${i}" variant="${i}">` 
                    + 
    
                    attributeInputFields.outerHTML
    
                    + 
                        
                    `</form>
                </div>
            `;
        }
    
        modalBodyDynamicPart = `
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                ${variantList}
            </ul>
            <div class="tab-content" id="myTabContent">
                ${tabContents}
            </div>
        `;
    
        $("#category_attributes_container").append(modalBodyDynamicPart);
    } else {
        $("#category_attributes_container").append(attributeInputFields);  
    }      
}

$("#action_btn_container button[type='submit'], #to_integration").mouseover(function() {
    let pickedAttributes;

    if ( $("input[name='categoryAttributes']").val() || !$("#category_trendyol").val() ) {
        return;
    } else {
        if ( $("#is_variation").is(":checked") ) {
            pickedAttributes = {};
            let variationCount = $("#variant_count").val();
            for (let i = 1; i <= variationCount; i++) {
                pickedAttributes['variant_' + i] = [];
                let categoryAttributeFormFields = $("#category_attributes_container form[variant=" + `${i}` + "] .form-control");
                categoryAttributeFormFields.each(function(index) {
                    if ($(this).attr("required") && !$(this).val()) {
                        alert('İlgili alanları doldur');
                    }
        
                    if ($(this).attr('placeholder') && $(this).val() !== "Open this select menu") {
                        collectPickedAttributesWithCustomValue(pickedAttributes['variant_' + i], Number($(this).attr('id')), $(this).val());
                    } else if ($(this).val() && $(this).val() !== "Open this select menu") {
                        collectPickedAttributesWithPreDefinedValue(pickedAttributes['variant_' + i], Number($(this).attr('id')), Number($(this).val()));
                    }
                });
            }
        } else {
            pickedAttributes = [];
            let categoryAttributeFormFields = $("#category_attributes_container .form-control");
            categoryAttributeFormFields.each(function(index) {
                if ($(this).attr("required") && !$(this).val()) {
                    alert('İlgili alanları doldur');
                }
    
                if ($(this).attr('placeholder') && $(this).val() !== "Open this select menu") {
                    collectPickedAttributesWithCustomValue(pickedAttributes, Number($(this).attr('id')), $(this).val());
                } else if ($(this).val() && $(this).val() !== "Open this select menu") {
                    collectPickedAttributesWithPreDefinedValue(pickedAttributes, Number($(this).attr('id')), Number($(this).val()));
                }
            });
        }
    }

    $("input[name='categoryAttributes']").val( JSON.stringify(pickedAttributes) );
});

function matchAttributes(categoryAttributesObject) {
    let categoryAttributes = categoryAttributesObject.categoryAttributes;
    let selectAttributes =  $(".trendyol-attributes");
    selectAttributes.each(function() {
        $(this).show();
    });
    for (let categoryAttribute of categoryAttributes) {
        selectAttributes.append(
            `
                <option value="${categoryAttribute.attribute.id}">${categoryAttribute.attribute.name}</option>
            `
        );
    }

    selectAttributes.change(function() {
        let relatedSelectContainer = $(this).next();
        relatedSelectContainer.text('');
        let ocVariationId = $(this).attr('variationId');
        let relatedVariation = $(".variant-list-container li[variationId=" + ocVariationId + "]");

        let selectedAttribute = categoryAttributes.find(categoryAttribute => categoryAttribute.attribute.id == $(this).val());

        console.log(selectedAttribute);

        let relatedVariants = relatedVariation.find("li");

        if (selectedAttribute.allowCustom == true) {
            relatedVariants.each(function() {

                relatedSelectContainer.append(
                    `
                        <input id="variation_${ocVariationId}_variant_${$(this).attr('variantId')}_equivalent" class="form-control" 
                            type="text" variantId=${$(this).attr('variantId')} placeholder="Equivalent value for ${$.trim($(this).text())}">
                    `
                );
            });
        } else {
            relatedVariants.each(function() {
                let selectAttributeValues = $("<select></select>");
                selectAttributeValues.attr({
                    class: 'form-control',
                    id: 'select_for_variant' + $(this).attr('variantId'),   
                    variant_id: $(this).attr('variantId'),                 
                });

                let relatedVariantName = $.trim( $(".variant-list li[variantid=" + $(this).attr('variantId') + "]").text() );
                selectAttributeValues.append(`
                    <option>Select equivalent value for ${relatedVariantName}</option>
                `);

                selectedAttribute.attributeValues.forEach(function(item, index, array) {                    
                    selectAttributeValues.append(`
                        <option value='${item.id}'>${item.name}</option>
                    `);
                });

                relatedSelectContainer.append(selectAttributeValues);
            });
        }
    });
}

function generateCategoryRow(name,data_id,required = false,value = "") {
    return `<div class="col-6 p-1 text-center">
                    <label for="cars"><b>${name}</b><span class="require-symbol">${required ? ' *' : ''}</span></label>
                    <input type="text" class="form-control" id="${data_id}" placeholder="Custom Value" ${required ? 'required' : ''}
                    value="${value}">
            </div>`;
}

function collectPickedAttributesWithPreDefinedValue(arrayToCollectIn, attributeId, attributeValueId) {
    arrayToCollectIn.push({
        attributeId: attributeId,
        attributeValueId: attributeValueId,
    });    
}

function collectPickedAttributesWithCustomValue(arrayToCollectIn, attributeId, customAttributeValue) {
    arrayToCollectIn.push({
        attributeId: attributeId,
        customAttributeValue: customAttributeValue,
    });    
}

function generateSelectForAttributes(attributeName, isRequired, attributeId, options) {
    return  `
             <div class="col-6 p-1 text-center">
                 <label for="cars"><b>${attributeName}</b><span class="require-symbol">${isRequired ? ' *' : ''}</span></label>
                 <select class="form-control" id="${attributeId}" ${isRequired ? 'required' : ''}>
                     <option ${isRequired ? 'disabled' : ''} value="">Open this select menu</option>`
                 +

                 options

                 +

                 `</select>
             </div>
            `;
}



