<?php namespace Visiosoft\SimpleClassifiedModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SimpleClassifiedModule\MatchedVariation\Contract\MatchedVariationRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\MatchedVariation\MatchedVariationRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedMatchedVariationsEntryModel;
use Visiosoft\SimpleClassifiedModule\MatchedVariation\MatchedVariationModel;
use Visiosoft\SimpleClassifiedModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedOrdersEntryModel;
use Visiosoft\SimpleClassifiedModule\Order\OrderModel;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\Contract\CategoryTemplateRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedCategoryTemplatesEntryModel;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateModel;
use Visiosoft\SimpleClassifiedModule\Brand\Contract\BrandRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\Brand\BrandRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedBrandsEntryModel;
use Visiosoft\SimpleClassifiedModule\Brand\BrandModel;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Contract\MatchedCategoryRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\MatchedCategoryRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedMatchedCategoriesEntryModel;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\MatchedCategoryModel;
use Visiosoft\SimpleClassifiedModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\SimpleClassifiedModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\SimpleClassified\SimpleClassifiedProductsEntryModel;
use Visiosoft\SimpleClassifiedModule\Product\ProductModel;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CustomForm\CustomFormBuilder;
use Illuminate\Routing\Router;

class SimpleClassifiedModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/simple_classified/matchedVariations'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedVariationsController@index',
        'admin/simple_classified/matchedVariations/create'    => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedVariationsController@create',
        'admin/simple_classified/matchedVariations/edit/{id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedVariationsController@edit',
        'admin/simple_classified/orders'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@index',
        'admin/simple_classified/orders/create'    => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@create',
        'admin/simple_classified/orders/edit/{id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@edit',
        'admin/simple_classified/categoryTemplates'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\CategoryTemplatesController@index',
        'admin/simple_classified/categoryTemplates/create' => [
            'as' => 'visiosoft.module.simple_classified::createPackage',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\CategoryTemplatesController@create'            
        ],
        'admin/simple_classified/categoryTemplates/edit/{id}' => [
            'as' => 'visiosoft.module.simple_classified::editTemplate',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\CategoryTemplatesController@edit'
        ],
        'admin/simple_classified/brands'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\BrandsController@index',
        'admin/simple_classified/brands/create'    => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\BrandsController@create',
        'admin/simple_classified/brands/edit/{id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\BrandsController@edit',
        'admin/simple_classified/matchedCategories'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedCategoriesController@index',
        'admin/simple_classified/matchedCategories/create'    => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedCategoriesController@create',
        'admin/simple_classified/matchedCategories/edit/{id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedCategoriesController@edit',
        'admin/simple_classified/matchCategories/{id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\MatchedCategoriesController@matchCategories',
        'admin/simple_classified'           => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\ProductsController@index',
        'admin/simple_classified/create'    => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\ProductsController@create',
        'admin/simple_classified/edit/{id}' => [
            'as' => 'visiosoft.module.simple_classified::editProduct',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\ProductsController@edit',
        ],
        'admin/simple_classified/delete/{id}' => [
            'as' => 'visiosoft.module.simple_classified::deleteProduct',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\ProductsController@delete',
        ],
        'admin/simple_classified/selectCategoryToCreateTemplate' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\CategoryTemplatesController@select',
        'admin/simple_classified/createCategoryTemplates' => 'Visiosoft\SimpleClassifiedModule\CategoryTemplate\CustomForm\CustomFormHandler@handle',
        'admin/getMatchedCategoriesAndTemplates/{market_names}/{categoryIds}' => [
            'as' => 'visiosoft.module.simple_classified::getMatchedCategoriesAndTemplates',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\AjaxController@returnMatchedCategoriesAndTemplates'
        ],
        'admin/getVariations/{categoryId}' => [
            'as' => 'visiosoft.module.simple_classified::getVariations',
            'uses' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\AjaxController@returnVariations'
        ],
        'admin/simple_classified/orders' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@index',
        'admin/simple_classified/pullOrders' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@pullOrders',
        'admin/simple_classified/createTestOrder' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\OrdersController@createTestOrder',
        'admin/simple_classified/fetch-selected-categories/{adv_id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\AjaxController@returnSelectedCategories',
        'admin/simple_classified/fetch-sub-categories/{cat_id}' => 'Visiosoft\SimpleClassifiedModule\Http\Controller\Admin\AjaxController@returnSubCategories',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SimpleClassifiedModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SimpleClassifiedModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\SimpleClassifiedModule\Event\ExampleEvent::class => [
        //    Visiosoft\SimpleClassifiedModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SimpleClassifiedModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SimpleClassifiedMatchedVariationsEntryModel::class => MatchedVariationModel::class,
        SimpleClassifiedOrdersEntryModel::class => OrderModel::class,
        SimpleClassifiedCategoryTemplatesEntryModel::class => CategoryTemplateModel::class,
        SimpleClassifiedBrandsEntryModel::class => BrandModel::class,
        SimpleClassifiedMatchedCategoriesEntryModel::class => MatchedCategoryModel::class,
        SimpleClassifiedProductsEntryModel::class => ProductModel::class,
        'all_in_one_form' => \Visiosoft\SimpleClassifiedModule\Product\Form\AllInOneFormBuilder::class,
        'edit_all_in_one_form' => \Visiosoft\SimpleClassifiedModule\Product\Form\EditAllInOneFormBuilder::class,
        'cool_categoryForm' => \Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\CoolCategoryFormBuilder::class,
        'category_match_form' => \Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\MatchCategoryFormBuilder::class,
        'create_category_template' => \Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form\CategoryTemplateFormBuilder::class,
        'edit_category_template' => \Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form\EditCategoryTemplateFormBuilder::class,
        'create_category' => \Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\CoolCategoryFormBuilder::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        MatchedVariationRepositoryInterface::class => MatchedVariationRepository::class,
        OrderRepositoryInterface::class => OrderRepository::class,
        CategoryTemplateRepositoryInterface::class => CategoryTemplateRepository::class,
        BrandRepositoryInterface::class => BrandRepository::class,
        MatchedCategoryRepositoryInterface::class => MatchedCategoryRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
