<?php namespace Visiosoft\SimpleClassifiedModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class SimpleClassifiedModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'products' => [
            'buttons' => [
                'new_product',
            ],
        ],
        'matchedCategories' => [
            'buttons' => [
                'new_matchedCategory',
            ],
        ],
        'categoryTemplates' => [
            'buttons' => [
                'new_categoryTemplate' => [
                    'data-toggle' => 'modal',
                    'data-target' => '#modal-large',
                    'href' => 'admin/simple_classified/selectCategoryToCreateTemplate',
                ],
            ],
        ],
        'orders' => [
            'buttons' => [
                'pull_orders' => [
                    'href' => 'admin/simple_classified/pullOrders',
                ],
                'create_test_order' => [
                    'href' => 'admin/simple_classified/createTestOrder',
                ]
            ],            
        ],
    ];

}
