<?php namespace Visiosoft\SimpleClassifiedModule\MatchedCategory\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class MatchedCategoryFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'category_oc' => [
            'type' => 'anomaly.field_type.text',
            'required' => true,            
            'readonly' => true,
        ],
        'category_trendyol' => [
            'type' => 'anomaly.field_type.text'
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'form_view' => 'visiosoft.module.simple_classified::admin/categories/matchCategory'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'visiosoft.module.simple_classified::css/main.css'
        ],        
    ];

}
