<?php namespace Visiosoft\SimpleClassifiedModule\MatchedCategory\Form;

use Visiosoft\SimpleClassifiedModule\MatchedCategory\MatchedCategoryRepository;
use Visiosoft\SimpleClassifiedModule\MatchedVariation\MatchedVariationRepository;

class MatchCategoryFormHandler
{
    public $entry;

    public function handle(MatchCategoryFormBuilder $builder)
    {            
        // save matched variants
        $savedMatchedVariants = app(MatchedVariationRepository::class);
        $matchedVariants = json_decode( $builder->getFormValue('matched_variants'), true );
        foreach($matchedVariants as $variant) {
            $savedMatchedVariants->create([
                'oc_categoryId' => $variant['oc_categoryId'],
                'oc_variationId' => $variant['oc_variationId'],
                'trendyol_variationId' => $variant['trendyol_variationId'],
                'oc_variantId' => $variant['oc_variantId'],
                'trendyol_variantId' => array_key_exists('trendyol_variantId', $variant) ? $variant['trendyol_variantId'] : null,
                'trendyol_variantText' => array_key_exists('trendyol_variantText', $variant) ? $variant['trendyol_variantText'] : null,
            ]);
        }


        // save matched categories

        $ocCategoryId = $builder->getFormValue('category_oc');

        $trendyolCategoryInputValue = $builder->getFormValue('category_trendyol');
        if ($trendyolCategoryInputValue) {
            $partsOfString = explode('-', $trendyolCategoryInputValue);
            $trendyolCategoryName = $partsOfString[1];
            $trendyolCategoryId = $partsOfString[0];

            if (!stripos(url()->previous(), 'edit')) {
                // save relationship between oc_category and trendyol_category
                $matchedCategories = app(MatchedCategoryRepository::class);
                $matchedCategory = $matchedCategories->create([
                    'oc_categoryId' => intval($ocCategoryId),
                    'trendyol_categoryId' => intval($trendyolCategoryId),
                    'trendyol_categoryName' => $trendyolCategoryName,
                ]);
            } else {
                // dd('girdi');
                // save relationship between oc_category and trendyol_category
                $matchedCategories = app(MatchedCategoryRepository::class);
                // dd($matchedCategories);
                // dd(intval($trendyolCategoryId));
                $matchedCategoryToBeUpdated = $matchedCategories->findBy('oc_categoryId', intval($ocCategoryId));
                $matchedCategory = $matchedCategoryToBeUpdated->update([
                    'oc_categoryId' => intval($ocCategoryId),
                    'trendyol_categoryId' => intval($trendyolCategoryId),
                    'trendyol_categoryName' => $trendyolCategoryName,
                ]);
            }
        }

        $n11CategoryInputValue = $builder->getFormValue('category_n11');
        if ($n11CategoryInputValue) {

        }

        $hepsiburadaCategoryInputValue = $builder->getFormValue('category_hepsiburada');
        if ($hepsiburadaCategoryInputValue) {

        }

        $gittigidiyorCategoryInputValue = $builder->getFormValue('category_gittigidiyor');
        if ($gittigidiyorCategoryInputValue) {

        }        

        return redirect('/admin/simple_classified/');
    }
}
