<?php namespace Visiosoft\SimpleClassifiedModule\MatchedCategory\Form;

use Illuminate\Http\Request;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CatsModule\Category\CategoryRepository;
use Visiosoft\AdvsModule\Productoption\ProductoptionRepository;
use Visiosoft\AdvsModule\ProductoptionsValue\ProductoptionsValueRepository;

class CoolCategoryFormHandler extends AdminController
{
    public function handle(CoolCategoryFormBuilder $builder, MessageBag $messages)
    {             
        // dd($builder->getChildFormEntry('category'));

        // First, let's add the entered category to the database.

        $allFields = $this->request->all();

        $enabledLangs = config('streams::locales.enabled');
        $allTranslatableFields = array();
        foreach ($allFields as $key => $value) {
            foreach ($enabledLangs as $lang) {
                if ($this->endsWith($key, "_$lang") && !in_array(substr($key, 0, -3), $allTranslatableFields)) {
                    $allTranslatableFields[] = substr($key, 0, -3);
                }
            }
        }

        $translatableCategoryFields = array_filter($allTranslatableFields, function($field) {
            if ( substr($field, 0, 9) === "category_" ) {
                return true;
            } else {
                return false;
            }
        });

        $translatableCategoryAttributes = array();
        foreach ($enabledLangs as $lang) {
            $translatableCategoryAttributes[$lang] = array();
            foreach ($translatableCategoryFields as $field) {
                $translatableCategoryAttributes[$lang][substr($field, 9)] = $allFields[$field . '_' . $lang];
            }
        }

        $unTranslatableCategoryAttributes = [
            'level' => '1',
            'parent_category_id' => null,
        ];

        $allCategoryAttributes = array_merge($translatableCategoryAttributes, $unTranslatableCategoryAttributes);

        $categories = app(CategoryRepository::class);
        $createdCategory = $categories->create($allCategoryAttributes);

        // Yes, the category entered has been successfully added to the database.
        // Now, let's associate the entered category variation with the category added to the database above.
        // And also add it to the database too. 

        $translatableProductOptionFields = array_filter($allTranslatableFields, function($field) {
            if ( substr($field, 0, 14) === "productoption_" ) {
                return true;
            } else {
                return false;
            }
        });

        // dd($translatableProductOptionFields);

        $translatableProductOptionAttributes = array();
        foreach ($enabledLangs as $lang) {
            $translatableProductOptionAttributes[$lang] = array();
            foreach ($translatableProductOptionFields as $field) {
                $translatableProductOptionAttributes[$lang][substr($field, 14)] = $allFields[$field . '_' . $lang];
            }
        }

        $unTranslatableProductOptionAttributes = [
            'category' => $createdCategory->id,
        ];

        $allProductOptionAttributes = array_merge($translatableProductOptionAttributes, $unTranslatableProductOptionAttributes);

        $productOptions = app(ProductoptionRepository::class);

        $createdProductOption = $productOptions->create($allProductOptionAttributes);

        // Yes, the category variation entered has been successfully added to the database.
        // Now, let's associate the entered category variation value with the category variation added to the database above.
        // And also add it to the database too. 

        $translatableProductOptionValueFields = array_filter($allTranslatableFields, function($field) {
            if ( substr($field, 0, 26) === "customProductoptionsValue_" ) {
                return true;
            } else {
                return false;
            }
        });

        $translatableProductOptionValueAttributes = array();
        foreach ($enabledLangs as $lang) {
            $translatableProductOptionValueAttributes[$lang] = array();
            foreach ($translatableProductOptionValueFields as $field) {
                $translatableProductOptionValueAttributes[$lang][substr($field, 26)] = $allFields[$field . '_' . $lang];
            }
        }

        $unTranslatableProductOptionValueAttributes = [
            'product_option_id' => $createdProductOption->id,
        ];

        $allProductOptionValueAttributes = array_merge($translatableProductOptionValueAttributes, $unTranslatableProductOptionValueAttributes);

        $categoryVariations = json_decode($allFields['variations'], true);
        $categoryVariants = json_decode($allFields['variants'], true);

        $productOptionValues = app(ProductoptionsValueRepository::class);

        $createdProductOptionValue = $productOptionValues->create($allProductOptionValueAttributes);

        // Other variants for first variation

        foreach($categoryVariants['variation_0'] as $variant) {
            $allProductOptionValueAttributes = array_merge($variant, $unTranslatableProductOptionValueAttributes);
            $createdProductOptionValue = $productOptionValues->create($allProductOptionValueAttributes);
        }

        // Operations for entered other category variations

        foreach ($categoryVariations as $variationNumber => $fieldsArray) {
            $allProductOptionAttributes = array_merge($fieldsArray, $unTranslatableProductOptionAttributes);
            $createdProductOption = $productOptions->create($allProductOptionAttributes);

            $unTranslatableProductOptionValueAttributes = [
                'product_option_id' => $createdProductOption->id,
            ];

            foreach($categoryVariants[$variationNumber] as $variant) {
                $allProductOptionValueAttributes = array_merge($variant, $unTranslatableProductOptionValueAttributes);
                $createdProductOptionValue = $productOptionValues->create($allProductOptionValueAttributes);
            }
        }
    }

    // helper function

    public function endsWith($string, $test)
    {
        $strlen = strlen($string);
        $testlen = strlen($test);
        if ($testlen > $strlen) return false;
        return substr_compare($string, $test, $strlen - $testlen, $testlen) === 0;
    }
}
