<?php namespace Visiosoft\SimpleClassifiedModule\MatchedCategory\Form;

use Anomaly\Streams\Platform\Ui\Form\Multiple\MultipleFormBuilder;

class CoolCategoryFormBuilder extends MultipleFormBuilder
{
    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        '*',
        'variations' => [
            'type' => 'visiosoft.field_type.json',
        ],
        'variants' => [
            'type' => 'visiosoft.field_type.json',
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [
        'general' => [
            'view' => 'visiosoft.module.simple_classified::admin/categories/createCategory'
        ]
    ];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'visiosoft.module.simple_classified::css/create-category.css'
        ],
        'scripts.js' => [
            'visiosoft.module.simple_classified::js/createCategory.js'
        ],
    ];

}
