<?php namespace Visiosoft\SimpleClassifiedModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\MatchedCategoryRepository;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateRepository;
use Visiosoft\AdvsModule\Productoption\ProductoptionRepository;
use Visiosoft\AdvsModule\ProductoptionsValue\ProductoptionsValueRepository;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class AjaxController extends AdminController
{
    public $category;
    public $adv;

    public function __construct(
        CategoryRepositoryInterface $category,
        AdvRepositoryInterface $adv
    )
    {
        $this->category = $category;
        $this->adv = $adv;
    }

    public function returnMatchedCategoriesAndTemplates($market_names, $categoryIds, MessageBag $messages)
    {
        $arrayToBeReturned = array();

        $market_namesArr = explode(',', $market_names);
        $categoryIdsArr = explode(',', $categoryIds);

        // Let's add the ids of the matched categories to the array we will return.

        $matchedCategories = app(MatchedCategoryRepository::class);
        $relevantCategory = $matchedCategories->findBy('oc_categoryId', end($categoryIdsArr));

        if (is_null($relevantCategory)) {
            $messages->error('Please first match the category you selected with relevant marketplace category');
            return;
        }

        $categoryTemplates = app(CategoryTemplateRepository::class);
        $categoryIdsArr_startFromTheMostSubCat = array_reverse($categoryIdsArr);

        $allCategoryTemplates = $categoryTemplates->all();
        $templateToBeReturned;

        for ($x = 0; $x < count( $categoryIdsArr_startFromTheMostSubCat ); $x++ ) {

            foreach($allCategoryTemplates as $categoryTemplate) {
                $attributes = json_decode($categoryTemplate->oc_categoryIds);

                if (in_array($categoryIdsArr_startFromTheMostSubCat[$x], $attributes)) {
                    $templateToBeReturned = $categoryTemplate;
                    break 2;
                }
            }
        }

        if (is_null($templateToBeReturned)) {
            $messages->error('Please first assign a template to your selected category for the relevant marketplace');
            return;
        }
        
        foreach ($market_namesArr as $market_name) {
            $arrayToBeReturned[$market_name . '_categoryId'] = $relevantCategory[$market_name . '_categoryId'];
            $arrayToBeReturned[$market_name . '_categoryName'] = $relevantCategory[$market_name . '_categoryName'];
            $arrayToBeReturned[$market_name . '_packageAttributes'] = $templateToBeReturned[$market_name . '_packageAttributes'];
        }

        return json_encode($arrayToBeReturned);
    }   

    public function returnVariations($categoryId) 
    {
        $categoryVariationsAndVariants = array();

        $allVariations = app(ProductoptionRepository::class);
        $categoryVariations = $allVariations->findAllBy('category', $categoryId);

        foreach ($categoryVariations as $variation) {
            $variation['id'] = $variation->id;
            $variation['name'] = $variation->name;

            $variants = array();
            $allVariants = app(ProductoptionsValueRepository::class);
            $variationVariants = $allVariants->findAllBy('product_option_id', $variation->id);
            foreach ($variationVariants as $variant) {
                array_push($variants, [
                    'id' => $variant->id,
                    'name' => $variant->name,
                ]);
            }
            $variation['variants'] = $variants;
            array_push($categoryVariationsAndVariants, $variation);
        }

        return json_encode($categoryVariationsAndVariants);
    }

    public function returnSelectedCategories($adv_id)
    {
        $advModel = new AdvModel();
        $relatedAdv = $advModel->newQuery()->where('advs_advs.id', $adv_id)->first();

        $relatedAdvCatIds = array();

        for ($i = 1; $i <= 10; $i++) {
            $catNumberPropertyName = 'cat' . $i;
            if ( $catId = $relatedAdv->$catNumberPropertyName ) {
                array_push($relatedAdvCatIds, $catId);
            } else {
                break;
            }
        }

        $relatedAdvCategories = array();

        $mainCategories = $this->category->getMainCategories()->pluck('name', 'id')->all();

        $mainCategoriesWithMoreInfo = array();        

        foreach($mainCategories as $categoryId => $categoryName) {
            $categoryObject = (object)[];
            $categoryObject->name = $categoryName;
            $categoryObject->id = $categoryId;
            $categoryObject->selected = $relatedAdv->cat1 == $categoryId ? true : false;

            array_push($mainCategoriesWithMoreInfo, $categoryObject);
        }

        array_push($relatedAdvCategories, $mainCategoriesWithMoreInfo);

        $index = 2;

        foreach($relatedAdvCatIds as $catId) {
            $subCategories = $this->category->getSubCatById($catId)->pluck('name', 'id')->all();

            if ( count($subCategories) > 0 ) {
                $subCategoriesWithMoreInfo = array();

                foreach($subCategories as $categoryId => $categoryName) {
                    $catNumberPropertyName = 'cat' . $index;
    
                    $categoryObject = (object)[];
                    $categoryObject->name = $categoryName;
                    $categoryObject->id = $categoryId;
                    $categoryObject->selected = (int)$relatedAdv->$catNumberPropertyName == $categoryId ? true : false;
        
                    array_push($subCategoriesWithMoreInfo, $categoryObject);
                }
    
                array_push($relatedAdvCategories, $subCategoriesWithMoreInfo);
                $index++;
            } else {
                break;
            }
        }

        return json_encode($relatedAdvCategories);
    }

    public function returnSubCategories($cat_id)
    {
        $relatedSubCategories = $this->category->getSubCatById($cat_id)->pluck('name', 'id')->all();
        return json_encode($relatedSubCategories);
    }
}