<?php namespace Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form;

use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateRepository;

class EditCategoryTemplateFormHandler
{
    public function handle(EditCategoryTemplateFormBuilder $builder)
    {    
        $templates = app(CategoryTemplateRepository::class);

        $ocCategoryIds = json_decode($builder->getFormValue('category_ids'));

        $templateToBeUpdated = $templates->find($builder->getEntry());

        $templateToBeUpdated->update([
            'oc_categoryIds' => json_encode($ocCategoryIds),
            'trendyol_packageAttributes' => json_encode([
                 'template_name' => $builder->getFormValue('template_name'),
                 'price_percentageChange' => $builder->getFormValue('price_percentageChange'),
                 'rounding_method' => $builder->getFormValue('rounding_method'),
                 'discount_policy' => $builder->getFormValue('discount_policy'),
                 'discount_type' => $builder->getFormValue('discount_type'),
                 'discount_value' => $builder->getFormValue('discount_value'),
                 'cargoCompany' => $builder->getFormValue('trendyol_cargoCompany'),
            ]),
        ]);
    }
}
