function pass_trendyolCategoryTemplate_toForm(packageAttributes) {
    debugger;
    $("#trendyol_cargoCompany").val( packageAttributes.cargoCompany );
    $("#price_percentageChange").val( packageAttributes.price_percentageChange );
    $("#rounding_method").val( packageAttributes.rounding_method );
    $("#discount_policy").val( packageAttributes.discount_policy );
    $("#discount_type").val( packageAttributes.discount_type );
    $("#discount_value").val( packageAttributes.discount_value );

    let trendyolPrices = calculateTrendyolPrices(packageAttributes);

    if ( packageAttributes.rounding_method == 'round_up' ) {
        $("#trendyol_standardPrice").val( Math.ceil( trendyolPrices.listPrice ) );
        $("#trendyol_price").val( Math.ceil( trendyolPrices.price ) );
    } else if ( packageAttributes.rounding_method == 'round_down' ) {
        $("#trendyol_standardPrice").val( Math.floor( trendyolPrices.listPrice ) );
        $("#trendyol_price").val( Math.floor( trendyolPrices.price ) );
    } else if ( packageAttributes.rounding_method == 'round_nearest' ) {
        $("#trendyol_standardPrice").val( Math.round( trendyolPrices.listPrice ) );
        $("#trendyol_price").val( Math.round( trendyolPrices.price ) );
    }
}

function calculateTrendyolPrices(packageAttributes) {
    let pricesObject = {};

    let discountPolicy = packageAttributes.discount_policy;

    let ocListPrice = parseInt( $("#standard_price").val() );
    let ocPrice = parseInt( $("#price_1").val() );
    let pricePercentageChange = parseInt( packageAttributes.price_percentageChange );

    if (discountPolicy == 'same_discount') {
        pricesObject.listPrice = ocListPrice + ocListPrice * (pricePercentageChange / 100);
        pricesObject.price = ocPrice + ocPrice * (pricePercentageChange / 100);
    } else if (discountPolicy == 'different_discount') {
        let discountType = packageAttributes.discount_type;
        let discountDifference = parseInt( packageAttributes.discount_value );
        pricesObject.price = ocPrice + ocPrice * (pricePercentageChange / 100);

        if (discountType == 'percentage') {
            let ocDiscountRate = (ocListPrice - ocPrice) * 100 / ocListPrice;
            let totalDiscountRate = discountDifference + ocDiscountRate;

            pricesObject.listPrice = pricesObject.price * 100 / (100 - totalDiscountRate);
        } else if (discountType == 'amount') {
            let ocDiscountAmount = ocListPrice - ocPrice;
            let totalDiscountAmount = discountDifference + ocDiscountAmount;

            pricesObject.listPrice = pricesObject.price + totalDiscountAmount;
        }
    }

    return pricesObject;
}