$(document).ready(function(){
    let currentPathPartials = window.location.pathname.split('/');
    let advId = currentPathPartials[currentPathPartials.length - 1];

    fetchSelectedCategories();

    function fetchSelectedCategories() {
        let url = `/admin/simple_classified/fetch-selected-categories/${advId}`;
        $.ajax({
            url: url,
            dataType: "json",
            success: function(categoryLevels) {
                categoryLevels.forEach(function(categoryLevel, levelIndex, array) {
                    relatedCatContainer = $(".cat" + (parseInt(levelIndex) + 1));
                    relatedCatContainer.show();
                    categoryLevel.forEach(function(category, catIndex, array) {
                        relatedCatContainer.find("select").append(`
                            <option value="${category.id}" ${category.selected ? 'selected' : ''}>${category.name}</option>
                        `);
                    });
                });
            }
        });        
    }

    $("select.cat-select").change(function() {
        let selectElement = $(this);
        let subCategoryContainers = $(this).parent().nextAll('.category-container');
        subCategoryContainers.each(function() {
            $(this).children('select').empty();
            $(this).hide();
        });

        $.ajax({
            url: `/admin/simple_classified/fetch-sub-categories/${$(this).children(":selected").attr("value")}`,
            dataType: "json",
            success: function(subCategoriesOfSelectedCategory) {
                console.log(subCategoriesOfSelectedCategory);
                for (let id in subCategoriesOfSelectedCategory) {
                    selectElement.parent().next().children('select').append(`
                        <option value="${id}">${subCategoriesOfSelectedCategory[id]}</option>
                    `);
                }

                if ( !(Array.isArray(subCategoriesOfSelectedCategory) && subCategoriesOfSelectedCategory.length == 0) ) {
                    selectElement.parent().next().show();
                }              
            }
        });        
    });
});