<?php namespace Visiosoft\SimpleClassifiedModule\Http\Controller\Admin;

use Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\CoolCategoryFormBuilder;
use Visiosoft\CatsModule\Category\Table\CategoryTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\MatchedCategoryFormBuilder;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\MatchCategoryFormBuilder;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Contract\MatchedCategoryRepositoryInterface;
use Visiosoft\CatsModule\Category\Form\CategoryFormBuilder;
use Visiosoft\AdvsModule\Productoption\Form\ProductoptionFormBuilder;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\CustomProductoptionsValueFormBuilder;

class MatchedCategoriesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param MatchedCategoryTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CategoryTableBuilder $table, CategoryRepositoryInterface $categoryRepositoryInterface)
    {
        $table->setButtons([
            'edit' => [
                'href' => '/admin/cats/edit/{entry.id}?parent={entry.parent_category_id}'
            ],
            'add_sub_category' => [
                'icon' => 'fa fa-caret-square-o-down',
                'type' => 'success',
                'href' => '/admin/cats/create?parent={entry.id}'
            ],
            'sub_category' => [
                'icon' => 'fa fa-caret-square-o-down',
                'type' => 'success',
                'href' => '/admin/cats?cat={entry.id}'
            ],
            'delete' => [
                'icon' => 'fa fa-trash',
                'type' => 'danger',
                'href' => function(EntryInterface $entry)
                {
                    return route('visiosoft.module.cats::admin.delete_category', ['id' => $entry->getId()])."?parent=".$entry->parent_category_id;
                }
            ],            
            'match_category' => [
                'enabled' => function (EntryInterface $entry, CategoryRepositoryInterface $categoryRepositoryInterface, MatchedCategoryRepositoryInterface $matchedCategoryRepositoryInterface)
                {
                    // If a category has sub category, it shouldn't have 'Match Category' button

                    // This button should not appear if a category has been matched.

                    $matchedCategories = app(MatchedCategoryRepositoryInterface::class);
                    
                    $wasThisCategoryMatched = $matchedCategories->findBy('oc_categoryId', $entry->getId());

                    return ( !(count($categoryRepositoryInterface->getSubCatById($entry->getId())) > 0) && !$wasThisCategoryMatched );
                },
                'href' => '/admin/simple_classified/matchCategories/{entry.id}',
            ],
            'edit_category_match' => [
                'enabled' => function (EntryInterface $entry, MatchedCategoryRepositoryInterface $matchedCategoryRepositoryInterface)
                {
                    // This button should not appear if a category has not been matched.

                    $matchedCategories = app(MatchedCategoryRepositoryInterface::class);
                    
                    $wasThisCategoryMatched = $matchedCategories->findBy('oc_categoryId', $entry->getId());

                    return ($wasThisCategoryMatched);                    
                },
                'href' => '/admin/simple_classified/matchedCategories/edit/{entry.id}',
            ]
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MatchedCategoryFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CoolCategoryFormBuilder $form, CategoryFormBuilder $categoryBuilder, ProductoptionFormBuilder $productoptionBuilder, 
    CustomProductoptionsValueFormBuilder $customProductoptionsValueBuilder)
    {
        $form->addForm('category', $categoryBuilder);
        $form->addForm('productoption', $productoptionBuilder);
        $form->addForm('customProductoptionsValue', $customProductoptionsValueBuilder);

        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MatchedCategoryFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MatchCategoryFormBuilder $form, $id)
    {
        return $this->view->make('visiosoft.module.simple_classified::admin/categories/editCategoryMatch', compact('id'));
    }

    public function matchCategories(MatchCategoryFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
