$(document).ready(function(){

    // When 'get input field' is clicked open 'stock input field' and vice versa

    $('#is_get_adv').change(function(){
        $('.visibleWhenGetOn').toggle();
    });

    $("#is_integration").change(function() {
        $('.visibleWhenIntegrationOn').toggle();
    });

    // Pazar yerlerinden en az bir tanesi seçildiğinde olacaklar

    $("#marketPlace_container input[type='checkbox']").change(function () {
        if ($("#marketPlace_container input:checkbox:checked").length > 0) {
            $("#action_btn_container .btn-success").hide();
            $("#to_integration").show();
        } else {
            $("#to_integration").hide();
            $("#action_btn_container .btn-success").show();
        }
    });

    // Next butonuna basıldığında ürün ekleme formu validate edilsin
    // Eğer validation başarılı olursa 'integration' sekmesine geçilsin

    $("#to_integration").click(function() {
        if ( $("form.add-product")[0].checkValidity() ) {
            $("#product_addition_tab").removeClass("active");
            $("#integration").toggle();
            $("#integration_tab").addClass("active");
    
            $("#pills-product_addition").removeClass("show active");
            $("#pills-integration").addClass("show active");

            let market_names = [];

            $("#marketPlace_container input:checkbox:checked").each(function(index) {
                market_names.push( $(this).attr('name') );
            });

            market_names.forEach(function(item, index, array) {
                $("." + item).show();
            });

            $("#to_integration").hide();

            if (market_names.length > 1) {
                $(".next-marketplace").show();
            } else {
                $("#action_btn_container .btn-success").show();
            }

            getMatchedCategoriesAndTemplates(market_names);
            // getMatchedVariationValues();
        } else {
            alert('Please fill all of the form fields');
            $("form.add-product").reportValidity();
        }
    });

    function getMatchedCategoriesAndTemplates(market_names) {
        let categoryIds = [];

        $(".category-container select").each(function(index) {
            categoryIds.push( $(this).find('option:selected').attr('value') );
        });

        let filteredCategoryIds = categoryIds.filter(function(item) {
            return item !== "";
        });

        console.log(filteredCategoryIds);
        console.log(market_names);

        $.ajax({
            url: `/admin/getMatchedCategoriesAndTemplates/${market_names}/${filteredCategoryIds}`,
            dataType: "json",
            success: function(categoryInformation) {                
                market_names.forEach(function(item, index, array) {                    
                    if ( categoryInformation[item + '_categoryId'] ) {           
                        $("#" + "category_" + item).val( categoryInformation[item + '_categoryId'] + ' - ' + categoryInformation[item + '_categoryName'] );
                        
                        let function_name = 'get_' + item + '_CategoryAttributes'; 
                        window[function_name](categoryInformation[item + '_categoryId']);
                    }

                    if ( categoryInformation[item + '_packageAttributes'] ) {
                        let packageAttributes = JSON.parse( categoryInformation[item + '_packageAttributes'] );
                        let function_name = 'pass_' + item + 'CategoryTemplate' + '_toForm';
                        window[function_name](packageAttributes);
                    }
                });
            },
            error: function(){
                location.reload();
            }
        });
    }

    let tabList = document.getElementById('pills-tab');

    tabList.onclick = function(event) {
        let clickedTab = event.target.closest('A');

        if (!clickedTab) return;

        let activeElement = tabList.querySelector('a.active');

        activeElement.className = 'nav-link';

        clickedTab.classList.add('active');
    }

    // determine what happens when the variation checkbox is clicked
    $("#is_variation").click(function(event) {
        $(".visibleWhenVariationOn").toggle();  
        if ( $("#is_variation").is(':checked') ) {
            duplicateVariantableFields( parseInt($("#variant_count").val()) );
        } else {
            // debugger;
            $(".variantable-container").each(function(index) {
                $(this).find('input').attr('placeholder', '');
            })
        }      
    }); 

    $("#cat1").change(function() {
        fetchCategoryVariations( $("#cat1").val() );
    });

    function fetchCategoryVariations(categoryId) {
        if (categoryId == "" || !$("#is_variation").is(':checked')) {
            return;
        }

        $.ajax({
            url: `/admin/getVariations/${categoryId}`,
            dataType: "json",
            success: function(variations) {
                restructureFormBasedOnVariations(variations);
            }
        });
    }

    function restructureFormBasedOnVariations(variations) {
        // variationInputsContainer = $("<div></div>");
        // variationInputsContainer.attr({
        //     class: 'row mt-2',
        // });

        variations.forEach(function(variation, index, array) {
            let variationInput = $("<select></select>");
            variationInput.attr({
                class: 'custom-select variantable mr-2',
                variation: `${variation.id}`,
            });

            variationInput.append(`
                <option>Open for the select menu</option>
            `);

            variation.variants.forEach(function(variant, index, array) {
                variationInput.append(`
                    <option value="${variant.id}">${variant.name}</option>
                `);
            });

            $("div#pills-general").append(`
                <div class="form-group mt-1 visibleWhenGetOn variantable-container variantable-select">
                    <label for="${variation.name}_1">${variation.name}</label>
                    <ul class="nav nav-pills visibleWhenVariationOn" id="${variation.name}_tabs" role="tablist">
                        <li class="nav-item" id="${variation.name}_tab_1">
                            <a class="nav-link active" id="${variation.name}_link_1" data-toggle="pill" href="#pills-${variation.name}-1" 
                            role="tab" aria-controls="pills-${variation.name}-1" aria-selected="true">Variant 1</a>
                        </li>
                    </ul>      
                    <div variant="1" class="tab-pane show active" id="pills-${variation.name}-1" role="tabpanel" aria-labelledby="pills-${variation.name}-1">
                        ${variationInput.prop('outerHTML')}                                          
                    </div>                                        
                </div>            
            `);
        });

        duplicateVariantableFields( parseInt($("#variant_count").val()) );
    }

    $("#variant_count").change(function() {
        duplicateVariantableFields($("#variant_count").val());
    });

    function duplicateVariantableFields(time) {
        $(".added").remove();

        $(".variantable-container.variantable-input").each(function(index) {
            let fieldName = $(this).find("ul").attr('id').split('_')[0];
            $(this).find("input.variantable").attr('placeholder', `${fieldName[0].toUpperCase() + fieldName.slice(1)} for variant 1`);
            for (let i = 2; i <= time; i++) {
                $(this).find("ul").append(`
                    <li class="nav-item added" id="${fieldName}_tab_${i}">
                        <a class="nav-link" id="${fieldName}_link_${i}" data-toggle="pill" href="#pills-${fieldName}-${i}" 
                            role="tab" aria-controls="pills-${fieldName}-${i}" aria-selected="false">Variant ${i}</a>
                    </li>                    
                `);

                $(this).append(`
                    <div class="tab-pane added" id="pills-${fieldName}-${i}" role="tabpanel" aria-labelledby="pills-${fieldName}-${i}">
                        <input variant=${i} class="form-control variantable" type="text" id="${fieldName}_${i}" placeholder="${fieldName[0].toUpperCase() + fieldName.slice(1)} for variant ${i}">                                                 
                    </div>                
                `);
            }
        });

        // $(".variantable-container").each(function(index) {
        //     $(this).after('<div class="variant-container"></div>');
        // });

        // $("input.variantable").each(function(index) {
        //     $(this).attr('placeholder', 'For Variant 1');
        //     $(this).attr('variant', '1');

        //     for (let i = 2; i <= time; i++) {
        //         $(this).next(".variant-container").append(`
        //             <input type="${$(this).attr('type')}" class="form-control variantable" id="${$(this).attr('id')}_variant_${i}" 
        //             name="${$(this).attr('id')}_variant_${i}" placeholder="For variant ${i}" variant="${i}"></input>
        //         `);
        //     }
        // });

        $(".variantable-container.variantable-select").each(function(index) {
            let fieldName = $(this).find("ul").attr('id').split('_')[0];
            let variationInput = $(this).find("select");
            for (let i = 2; i <= time; i++) {
                $(this).find("ul").append(`
                    <li class="nav-item added" id="${fieldName}_tab_${i}">
                        <a class="nav-link" id="${fieldName}_link_${i}" data-toggle="pill" href="#pills-${fieldName}-${i}" 
                            role="tab" aria-controls="pills-${fieldName}-${i}" aria-selected="false">Variant ${i}</a>
                    </li>                    
                `);

                $(this).append(`
                    <div class="tab-pane added" variant="${i}" id="pills-${fieldName}-${i}" role="tabpanel" aria-labelledby="pills-${fieldName}-${i}">
                        ${variationInput.prop('outerHTML')}                                                   
                    </div>                
                `);
            }            
        });
    }

    function deleteAllVariantFields() {
        $("div.variant-container").text('');
        $("div.variation-container").remove();
        $("input.variantable").attr('placeholder', ''); 
    }

    // collect variation values and fill the related 'variationValues' form field.
    $("#action_btn_container button[type='submit']").mouseover(collectVariationValues);

    function collectVariationValues() {
        /*
            [
                variationCount => 2,
                variants => [
                    variant_1 => [
                        price => 10,
                        currency => TRY,
                        stock => 3,
                        options => [
                            1 => 1,
                            2 => 3,
                        ],
                        marketPlacesAttributes => [
                            trendyol => [
                                barcode => 7771827564738,
                                stockCode => 73828867413,
                                dimensionalWeight => 3,
                                standardPrice => 600,              
                                categoryAttributes => [
                                    id => valueId,
                                    id => valueId,
                                    id => valueId,
                                    id => valueId,
                                ],            
                            ]
                        ]
                    ],
                    variant_2 => [
                        price => 10,
                        currency => TRY,
                        stock => 5,
                        barcode => 7771827564737,
                        stockCode => 73828867414,
                        dimensionalWeight => 3,        
                        standardPrice => 600,    
                        categoryAttributes => [
                            trendyol => json,
                            n11 => json,
                        ],
                        options => [
                            1 => 2,
                            2 => 4,
                        ],                           
                    ],
                ]
            ]
        */

        if ( $("#is_variation").is(":checked") ) {
            let collectedVariationValues = {};

            let variationCount = $("#variant_count").val();
            collectedVariationValues.variationCount = variationCount;
            collectedVariationValues.variants = {};
    
            for (let i = 1; i <= variationCount; i++) {
                let variantPropertyName = 'variant_' + i; 
                collectedVariationValues.variants[variantPropertyName] = {
                    price: $("[id^=price][variant=" + i + "]").val(),
                    stock: $("[id^=stock][variant=" + i + "]").val(),
                    barcode: $("[id^=barcode][variant=" + i + "]").val(),
                    stockCode: $("[id^=stockCode][variant=" + i + "]").val(),
                    dimensionalWeight: $("[id^=dimensionalWeight][variant=" + i + "]").val(),   
                    categoryAttributes: {
                        trendyol: $("input[name='categoryAttributes']").val(),
                    }                 
                }

                collectedVariationValues.variants[variantPropertyName].options = {};
                $(".variantable-container.variantable-select").each(function(variation) {
                    variationId = $(this).find("div[variant=" + i + "] select").attr('variation');
                    variantId = $(this).find("div[variant=" + i + "] select").val();
                    if (!isNaN(parseInt(variantId))) {
                        collectedVariationValues.variants[variantPropertyName].options[variationId] = variantId;
                    }
                });
            }

            $("input[name='variationValues']").val( JSON.stringify(collectedVariationValues) );
        }
    }
});