$(document).ready(function(){
    let clickCounter = 1;
    let selectedLanguage = $("div.dropdown-menu .active").first().attr('lang');

    $("body").on("click", ".add-variant-button", function() {
        debugger;
        selectedLanguage = $("div.dropdown-menu .active").first().attr('lang');

        let variationCount = $(this).parent().attr('variation');

        let newClickCount = Number($(this).attr('clickCount')) + 1;

        $(this).attr('clickCount', newClickCount);

        let variant = createVariantInput(selectedLanguage, variationCount, Number($(this).attr('clickCount')));

        if ( $(this).prev('p').length ) {
            $(this).prev('p').before(variant);
        } else {
            $(this).before(variant);
        }
    });

    $("div.dropdown-menu a").click(function() {
        selectedLanguage = $("div.dropdown-menu .active").first().attr('lang');
        newLanguage = $(this).attr('lang');

        if ( $(this).attr('lang') !== selectedLanguage ) {
            $("input[lang=" + selectedLanguage + "]").each(function() {
                $(this).hide();
            });

            if ( $("input[lang=" + $(this).attr('lang') + "]").length > 0 ) {
                $("input[lang=" + $(this).attr('lang') + "]").each(function() {
                    debugger;
                    $(this).show();
                });

                $(".variation-container").each(function() {
                    let currentVariantCount = $(this).find("input.variant[lang=" + newLanguage + "]").length;

                    let btn = $(this).find("button.add-variant-button");

                    let newVariantCount;

                    if ($(this).attr('variation') == '0') {
                        newVariantCount = Number(btn.attr('clickCount'));

                        for (let i = currentVariantCount; i < newVariantCount; i++) {
                            let variant = createVariantInput(newLanguage, $(this).attr('variation'), i + 1);
                                
                            btn.before(variant);
                        }  
                    } else {
                        newVariantCount = Number(btn.attr('clickCount')) + 1;

                        for (let i = currentVariantCount; i < newVariantCount; i++) {
                            let variant = createVariantInput(newLanguage, $(this).attr('variation'), i);
                                                            
                            btn.before(variant);
                        }  
                    }                      
                });
            } else {
                $(".variation-container").each(function() {
                    let btn = $(this).find("button.add-variant-button");

                    let variantCount = btn.attr('clickCount');

                    if ( $(this).attr('variation') == '0' ) {
                        for (let i = 0; i < variantCount; i++) {
                            let variant = createVariantInput(newLanguage, $(this).attr('variation'), i + 1);
                                
                            btn.before(variant);
                        }
                    } else {
                        let variationInput = createVariationInput(newLanguage, $(this).attr('variation'));

                        btn.before(variationInput);

                        for (let i = 0; i <= variantCount; i++) {
                            let variant = createVariantInput(newLanguage, $(this).attr('variation'), i);
                                
                            btn.before(variant);
                        }
                    }
                });
            }
        }
    });

    let variationCount = 1; 

    $("#add_variation").click(function() {
        selectedLanguage = $("div.dropdown-menu .active").first().attr('lang');

        let variationContainer = $("<div></div>");
        variationContainer.attr({
            class: 'variation-container mt-2',
            id: 'variation_container_' + variationCount,
            variation: variationCount,
        });

        let variationInput = createVariationInput(selectedLanguage, variationCount, 'Type a new variation name');

        let addVariantButton = $("<button>Add Variant</button>");
        addVariantButton.attr({
            class: 'btn btn-primary add-variant-button',
            type: 'button',
            variation: variationCount,
            clickCount: 0,
        });

        let variant = createVariantInput(selectedLanguage, variationCount, addVariantButton.attr('clickCount'), 'Type a variant name for the new variation');

        variationContainer.append(variationInput, variant, addVariantButton);
        $("#add_variation").before(variationContainer);

        variationCount++;
    });

    $("button[name='action']").click(function() {        
        let variationsObject = {};

        let variations = $("div.variation-container");

        variations.each(function() {
            if ( $(this).attr('variation') !== '0' ) {
                let variationPropertyName = 'variation_' + $(this).attr('variation');
                variationsObject[variationPropertyName] = {};

                let translationsOfVariation = $(this).children(".variation");
                translationsOfVariation.each(function() {
                    let langPropertyName = $(this).attr('lang');
                    variationsObject[variationPropertyName][langPropertyName] = {
                        name: $(this).val(),
                    };
                });
            }
        });

        $("input[name='variations']").val( JSON.stringify(variationsObject) );

        let variantsObject = {};

        variations.each(function() {
            debugger;
            let relatedVariation = $(this);
            let variationPropertyName = 'variation_' + $(this).attr('variation');
            variantsObject[variationPropertyName] = {};
            
            let variants = $(this).find(".variant:visible");
            variants.each(function() {
                let variantPropertyName = 'variant_' + $(this).attr('variant');
                variantsObject[variationPropertyName][variantPropertyName] = {};
                let translationOfVariants = relatedVariation.find("input[variant=" + $(this).attr('variant') + "]");

                translationOfVariants.each(function() {
                    let languagePropertyName = $(this).attr('lang');
                    variantsObject[variationPropertyName][variantPropertyName][languagePropertyName] = {
                        name: $(this).val(),
                    };
                });
            });
        });

        $("input[name='variants']").val( JSON.stringify(variantsObject) );
    });

    function createVariantInput(newLanguage, variation, variant, placeholder = "") {
        let input = $("<input>");
    
        input.attr({
            class: 'form-control variant',
            type: 'text',
            variation: $(this).attr('variation'),
            variant: variant,
            lang: newLanguage,
            placeholder: placeholder,
        });
    
        return input;
    }  

    function createVariationInput(newLanguage, variation, placeholder = "") {
        let input = $("<input>");
    
        input.attr({
            class: 'form-control variation',
            type: 'text',
            variation: variation,
            lang: newLanguage,
            placeholder: placeholder,
        });
    
        return input;
    }  
});

