<?php namespace Visiosoft\SimpleClassifiedModule\Product\Form;

use Visiosoft\AdvsModule\Status\Contract\StatusRepositoryInterface;

class EditAllInOneFormFields
{
    public function handle(EditAllInOneFormBuilder $builder, StatusRepositoryInterface $statusRepository)
    {
        $statuses = $statusRepository->all()->pluck('name', 'slug')->all();

        $form_fields = [
            '*',
            'trendyol' => [
                'type' => 'anomaly.field_type.boolean',
            ],
            'n11' => [
                'type' => 'anomaly.field_type.boolean',
            ],
            'hepsiburada' => [
                'type' => 'anomaly.field_type.boolean',
            ],
            'gittigidiyor' => [
                'type' => 'anomaly.field_type.boolean',
            ],
            'brand_name' => [
                'type' => 'anomaly.field_type.text',
            ],
            'barcode_number' => [
                'type' => 'anomaly.field_type.text',
            ],
            'stock_code' => [
                'type' => 'anomaly.field_type.text',
            ],
            'status' => [
                'type' => 'anomaly.field_type.select',
                "config" => [
                    'default_value' => 'approved',
                    "options" => $statuses,
                    "mode" => "search",
                ]
            ],
            'productMainId' => [
                'label' => 'visiosoft.module.trendyol::field.productMainId.label',
                'instructions' => 'visiosoft.module.trendyol::field.productMainId.instructions',
                'type' => 'anomaly.field_type.text',
            ],
            'brand' => [
                'label' => 'visiosoft.module.trendyol::field.brand.label',
                'instructions' => 'visiosoft.module.trendyol::field.brand.instructions',
                'type' => 'anomaly.field_type.text',
                'config' => [
                    'mode' => 'search'
                ],
            ],
            'category_trendyol' => [
                'label' => 'visiosoft.module.trendyol::field.category.label',
                'instructions' => 'visiosoft.module.trendyol::field.category.instructions',
                'type' => 'anomaly.field_type.text',
                'config' => [
                    'mode' => 'search',
                ],
    
            ],
            'categoryAttributes' => [
                'type' => 'visiosoft.field_type.json',
            ],
            'dimensionalWeight' => [
                'label' => 'visiosoft.module.trendyol::field.dimensionalWeight.label',
                'instructions' => 'visiosoft.module.trendyol::field.dimensionalWeight.instructions',
                'type' => 'anomaly.field_type.text',
                'rules' => [
                    'not_regex:/[a-zA-Z]/',
                ]
    
            ],
            'trendyol_cargoCompany' => [
                'label' => 'visiosoft.module.trendyol::field.cargoCompany.label',
                'instructions' => 'visiosoft.module.trendyol::field.cargoCompany.instructions',
                'type' => 'anomaly.field_type.text',
            ],
            'trendyol_price' => [
                'label' => 'Price',
                'type' => 'anomaly.field_type.integer',
            ],
            'trendyol_standardPrice' => [
                'label' => 'Standard Price',
                'type' => 'anomaly.field_type.integer',
            ],
            'price_percentageChange' => [
                'label' => 'Price Percentage Change',
                'type' => 'anomaly.field_type.integer'
            ],
            'rounding_method' => [
                'label' => 'Rounding Method',
                'type' => 'anomaly.field_type.select'
            ],
            'discount_policy' => [
                'label' => 'Discount Policy',
                'type' => 'anomaly.field_type.select'
            ],
            'discount_type' => [
                'label' => 'Discount Type',
                'type' => 'anomaly.field_type.select'
            ],
            'discount_value' => [
                'label' => 'Discount Value',
                'type' => 'anomaly.field_type.integer'
            ],
        ];

        $builder->setFields($form_fields);
    }
}

